/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.lateral.socket.tcp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jcs.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs.auxiliary.lateral.LateralCacheNoWait;
import org.apache.commons.jcs.auxiliary.lateral.LateralCacheNoWaitFacade;
import org.apache.commons.jcs.auxiliary.lateral.behavior.ILateralCacheAttributes;
import org.apache.commons.jcs.auxiliary.lateral.socket.tcp.LateralTCPCacheManager;
import org.apache.commons.jcs.auxiliary.lateral.socket.tcp.TCPLateralCacheAttributes;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs.utils.discovery.DiscoveredService;
import org.apache.commons.jcs.utils.discovery.behavior.IDiscoveryListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LateralTCPDiscoveryListener
implements IDiscoveryListener {
    private static final Log log = LogFactory.getLog(LateralTCPDiscoveryListener.class);
    private final Map<String, LateralCacheNoWaitFacade<?, ?>> facades = Collections.synchronizedMap(new HashMap());
    private final Set<String> knownDifferentlyConfiguredRegions = Collections.synchronizedSet(new HashSet());
    private final ICompositeCacheManager cacheMgr;
    private final ICacheEventLogger cacheEventLogger;
    private final IElementSerializer elementSerializer;

    protected LateralTCPDiscoveryListener(ICompositeCacheManager cacheMgr, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        this.cacheMgr = cacheMgr;
        this.cacheEventLogger = cacheEventLogger;
        this.elementSerializer = elementSerializer;
    }

    public synchronized boolean addNoWaitFacade(String cacheName, LateralCacheNoWaitFacade<?, ?> facade) {
        boolean isNew = !this.containsNoWaitFacade(cacheName);
        this.facades.put(cacheName, facade);
        this.knownDifferentlyConfiguredRegions.remove(cacheName);
        return isNew;
    }

    public boolean containsNoWaitFacade(String cacheName) {
        return this.facades.containsKey(cacheName);
    }

    public <K, V> boolean containsNoWait(String cacheName, LateralCacheNoWait<K, V> noWait) {
        LateralCacheNoWaitFacade<?, ?> facade = this.facades.get(noWait.getCacheName());
        if (facade == null) {
            return false;
        }
        return facade.containsNoWait(noWait);
    }

    protected <K, V> boolean addNoWait(LateralCacheNoWait<K, V> noWait) {
        LateralCacheNoWaitFacade<?, ?> facade = this.facades.get(noWait.getCacheName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("addNoWait > Got facade for " + noWait.getCacheName() + " = " + facade));
        }
        if (facade != null) {
            boolean isNew = facade.addNoWait(noWait);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Called addNoWait, isNew = " + isNew));
            }
            return isNew;
        }
        if (!this.knownDifferentlyConfiguredRegions.contains(noWait.getCacheName())) {
            if (log.isInfoEnabled()) {
                log.info((Object)("addNoWait > Different nodes are configured differently or region [" + noWait.getCacheName() + "] is not yet used on this side.  "));
            }
            this.knownDifferentlyConfiguredRegions.add(noWait.getCacheName());
        }
        return false;
    }

    protected <K, V> boolean removeNoWait(LateralCacheNoWait<K, V> noWait) {
        LateralCacheNoWaitFacade<?, ?> facade = this.facades.get(noWait.getCacheName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeNoWait > Got facade for " + noWait.getCacheName() + " = " + facade));
        }
        if (facade != null) {
            boolean removed = facade.removeNoWait(noWait);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Called removeNoWait, removed " + removed));
            }
            return removed;
        }
        if (!this.knownDifferentlyConfiguredRegions.contains(noWait.getCacheName())) {
            if (log.isInfoEnabled()) {
                log.info((Object)("removeNoWait > Different nodes are configured differently or region [" + noWait.getCacheName() + "] is not yet used on this side.  "));
            }
            this.knownDifferentlyConfiguredRegions.add(noWait.getCacheName());
        }
        return false;
    }

    @Override
    public void addDiscoveredService(DiscoveredService service) {
        LateralTCPCacheManager lcm = this.findManagerForServiceEndPoint(service);
        ArrayList<String> regions = service.getCacheNames();
        if (regions != null) {
            for (String cacheName : regions) {
                try {
                    AuxiliaryCache ic = lcm.getCache(cacheName);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Got cache, ic = " + ic));
                    }
                    if (ic == null) continue;
                    this.addNoWait((LateralCacheNoWait)ic);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Called addNoWait for cacheName [" + cacheName + "]"));
                }
                catch (Exception e) {
                    log.error((Object)"Problem creating no wait", (Throwable)e);
                }
            }
        } else {
            log.warn((Object)("No cache names found in message " + service));
        }
    }

    @Override
    public void removeDiscoveredService(DiscoveredService service) {
        LateralTCPCacheManager lcm = this.findManagerForServiceEndPoint(service);
        ArrayList<String> regions = service.getCacheNames();
        if (regions != null) {
            for (String cacheName : regions) {
                try {
                    AuxiliaryCache ic = lcm.getCache(cacheName);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Got cache, ic = " + ic));
                    }
                    if (ic == null) continue;
                    this.removeNoWait((LateralCacheNoWait)ic);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Called removeNoWait for cacheName [" + cacheName + "]"));
                }
                catch (Exception e) {
                    log.error((Object)"Problem removing no wait", (Throwable)e);
                }
            }
        } else {
            log.warn((Object)("No cache names found in message " + service));
        }
    }

    private LateralTCPCacheManager findManagerForServiceEndPoint(DiscoveredService service) {
        TCPLateralCacheAttributes lca = new TCPLateralCacheAttributes();
        lca.setTransmissionType(ILateralCacheAttributes.Type.TCP);
        lca.setTcpServer(service.getServiceAddress() + ":" + service.getServicePort());
        LateralTCPCacheManager lcm = LateralTCPCacheManager.getInstance(lca, this.cacheMgr, this.cacheEventLogger, this.elementSerializer);
        return lcm;
    }
}

