/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.lateral.socket.tcp;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jcs.auxiliary.lateral.socket.tcp.LateralTCPDiscoveryListener;
import org.apache.commons.jcs.auxiliary.lateral.socket.tcp.behavior.ITCPLateralCacheAttributes;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LateralTCPDiscoveryListenerManager {
    private final Map<String, LateralTCPDiscoveryListener> instances = Collections.synchronizedMap(new HashMap());
    private static final Log log = LogFactory.getLog(LateralTCPDiscoveryListenerManager.class);

    public LateralTCPDiscoveryListenerManager() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Creating new LateralTCPDiscoveryListenerManager");
        }
    }

    public synchronized LateralTCPDiscoveryListener getDiscoveryListener(ITCPLateralCacheAttributes ilca, ICompositeCacheManager cacheMgr, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        String key = ilca.getUdpDiscoveryAddr() + ":" + ilca.getUdpDiscoveryPort();
        LateralTCPDiscoveryListener ins = this.instances.get(key);
        if (ins == null) {
            ins = new LateralTCPDiscoveryListener(cacheMgr, cacheEventLogger, elementSerializer);
            this.instances.put(key, ins);
            if (log.isInfoEnabled()) {
                log.info((Object)("Created new discovery listener for " + key + " cacheName for request " + ilca.getCacheName()));
            }
        }
        return ins;
    }
}

