/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.lateral.socket.tcp;

import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.jcs.access.exception.CacheException;
import org.apache.commons.jcs.auxiliary.lateral.LateralElementDescriptor;
import org.apache.commons.jcs.auxiliary.lateral.behavior.ILateralCacheListener;
import org.apache.commons.jcs.auxiliary.lateral.socket.tcp.behavior.ITCPLateralCacheAttributes;
import org.apache.commons.jcs.engine.CacheInfo;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs.engine.behavior.IShutdownObserver;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.jcs.engine.control.CompositeCacheManager;
import org.apache.commons.jcs.io.ObjectInputStreamClassLoaderAware;
import org.apache.commons.jcs.utils.threadpool.DaemonThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LateralTCPListener<K, V>
implements ILateralCacheListener<K, V>,
IShutdownObserver {
    private static final Log log = LogFactory.getLog(LateralTCPListener.class);
    private static final int acceptTimeOut = 1000;
    private transient ICompositeCacheManager cacheManager;
    private static final HashMap<String, ILateralCacheListener<?, ?>> instances = new HashMap();
    private ListenerThread receiver;
    private ITCPLateralCacheAttributes tcpLateralCacheAttributes;
    private int port;
    private ExecutorService pooledExecutor;
    private int putCnt = 0;
    private int removeCnt = 0;
    private int getCnt = 0;
    private long listenerId = CacheInfo.listenerId;
    private boolean shutdown = false;
    private boolean terminated = false;

    public static synchronized <K, V> LateralTCPListener<K, V> getInstance(ITCPLateralCacheAttributes ilca, ICompositeCacheManager cacheMgr) {
        LateralTCPListener<K, V> ins = (LateralTCPListener<K, V>)instances.get(String.valueOf(ilca.getTcpListenerPort()));
        if (ins == null) {
            ins = new LateralTCPListener<K, V>(ilca);
            ins.init();
            ins.setCacheManager(cacheMgr);
            instances.put(String.valueOf(ilca.getTcpListenerPort()), ins);
            if (log.isInfoEnabled()) {
                log.info((Object)("Created new listener " + ilca.getTcpListenerPort()));
            }
        }
        return ins;
    }

    protected LateralTCPListener(ITCPLateralCacheAttributes ilca) {
        this.setTcpLateralCacheAttributes(ilca);
    }

    @Override
    public synchronized void init() {
        try {
            this.port = this.getTcpLateralCacheAttributes().getTcpListenerPort();
            this.pooledExecutor = Executors.newCachedThreadPool(new DaemonThreadFactory("JCS-LateralTCPListener-"));
            this.terminated = false;
            this.shutdown = false;
            log.info((Object)("Listening on port " + this.port));
            ServerSocket serverSocket = new ServerSocket(this.port);
            serverSocket.setSoTimeout(1000);
            this.receiver = new ListenerThread(serverSocket);
            this.receiver.setDaemon(true);
            this.receiver.start();
        }
        catch (Exception ex) {
            log.error((Object)ex);
            throw new IllegalStateException(ex.getMessage());
        }
    }

    @Override
    public void setListenerId(long id) throws IOException {
        this.listenerId = id;
        if (log.isDebugEnabled()) {
            log.debug((Object)("set listenerId = " + id));
        }
    }

    @Override
    public long getListenerId() throws IOException {
        return this.listenerId;
    }

    @Override
    public void handlePut(ICacheElement<K, V> element) throws IOException {
        ++this.putCnt;
        if (log.isInfoEnabled() && this.getPutCnt() % 100 == 0) {
            log.info((Object)("Put Count (port " + this.getTcpLateralCacheAttributes().getTcpListenerPort() + ") = " + this.getPutCnt()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("handlePut> cacheName=" + element.getCacheName() + ", key=" + element.getKey()));
        }
        this.getCache(element.getCacheName()).localUpdate(element);
    }

    @Override
    public void handleRemove(String cacheName, K key) throws IOException {
        ++this.removeCnt;
        if (log.isInfoEnabled() && this.getRemoveCnt() % 100 == 0) {
            log.info((Object)("Remove Count = " + this.getRemoveCnt()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("handleRemove> cacheName=" + cacheName + ", key=" + key));
        }
        this.getCache(cacheName).localRemove(key);
    }

    @Override
    public void handleRemoveAll(String cacheName) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("handleRemoveAll> cacheName=" + cacheName));
        }
        this.getCache(cacheName).localRemoveAll();
    }

    public ICacheElement<K, V> handleGet(String cacheName, K key) throws IOException {
        ++this.getCnt;
        if (log.isInfoEnabled() && this.getGetCnt() % 100 == 0) {
            log.info((Object)("Get Count (port " + this.getTcpLateralCacheAttributes().getTcpListenerPort() + ") = " + this.getGetCnt()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("handleGet> cacheName=" + cacheName + ", key = " + key));
        }
        return this.getCache(cacheName).localGet(key);
    }

    public Map<K, ICacheElement<K, V>> handleGetMatching(String cacheName, String pattern) throws IOException {
        ++this.getCnt;
        if (log.isInfoEnabled() && this.getGetCnt() % 100 == 0) {
            log.info((Object)("GetMatching Count (port " + this.getTcpLateralCacheAttributes().getTcpListenerPort() + ") = " + this.getGetCnt()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("handleGetMatching> cacheName=" + cacheName + ", pattern = " + pattern));
        }
        return this.getCache(cacheName).localGetMatching(pattern);
    }

    public Set<K> handleGetKeySet(String cacheName) throws IOException {
        return this.getCache(cacheName).getKeySet(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleDispose(String cacheName) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("handleDispose > cacheName=" + cacheName + " | Ignoring message.  Do not dispose from remote."));
        }
        LateralTCPListener lateralTCPListener = this;
        synchronized (lateralTCPListener) {
            this.terminated = true;
        }
    }

    @Override
    public synchronized void dispose() {
        this.terminated = true;
        this.notify();
        this.pooledExecutor.shutdownNow();
    }

    protected CompositeCache<K, V> getCache(String name) {
        if (this.getCacheManager() == null) {
            try {
                this.setCacheManager(CompositeCacheManager.getInstance());
            }
            catch (CacheException e) {
                throw new RuntimeException("Could not retrieve cache manager instance", e);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("cacheMgr = " + this.getCacheManager()));
            }
        }
        return this.getCacheManager().getCache(name);
    }

    public int getPutCnt() {
        return this.putCnt;
    }

    public int getGetCnt() {
        return this.getCnt;
    }

    public int getRemoveCnt() {
        return this.removeCnt;
    }

    @Override
    public void setCacheManager(ICompositeCacheManager cacheMgr) {
        this.cacheManager = cacheMgr;
    }

    @Override
    public ICompositeCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setTcpLateralCacheAttributes(ITCPLateralCacheAttributes tcpLateralCacheAttributes) {
        this.tcpLateralCacheAttributes = tcpLateralCacheAttributes;
    }

    public ITCPLateralCacheAttributes getTcpLateralCacheAttributes() {
        return this.tcpLateralCacheAttributes;
    }

    @Override
    public void shutdown() {
        if (!this.shutdown) {
            this.shutdown = true;
            if (log.isInfoEnabled()) {
                log.info((Object)"Shutting down TCP Lateral receiver.");
            }
            this.receiver.interrupt();
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Shutdown already called.");
        }
    }

    public class ConnectionHandler
    implements Runnable {
        private final Socket socket;

        public ConnectionHandler(Socket socket) {
            this.socket = socket;
        }

        @Override
        public void run() {
            ObjectInputStreamClassLoaderAware ois;
            try {
                ois = new ObjectInputStreamClassLoaderAware(this.socket.getInputStream(), null);
            }
            catch (Exception e) {
                log.error((Object)("Could not open ObjectInputStream on " + this.socket), (Throwable)e);
                return;
            }
            try {
                while (true) {
                    LateralElementDescriptor led;
                    if ((led = (LateralElementDescriptor)ois.readObject()) == null) {
                        log.debug((Object)"LateralElementDescriptor is null");
                        continue;
                    }
                    if (led.requesterId == LateralTCPListener.this.getListenerId()) {
                        log.debug((Object)"from self");
                        continue;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("receiving LateralElementDescriptor from anotherled = " + led + ", led.command = " + (Object)((Object)led.command) + ", led.ce = " + led.ce));
                    }
                    this.handle(led);
                }
            }
            catch (EOFException e) {
                log.info((Object)("Caught java.io.EOFException closing connection." + e.getMessage()));
            }
            catch (SocketException e) {
                log.info((Object)("Caught java.net.SocketException closing connection." + e.getMessage()));
            }
            catch (Exception e) {
                log.error((Object)"Unexpected exception.", (Throwable)e);
            }
            try {
                ois.close();
            }
            catch (IOException e) {
                log.error((Object)"Could not close object input stream.", (Throwable)e);
            }
        }

        private void handle(LateralElementDescriptor<K, V> led) throws IOException {
            String cacheName = led.ce.getCacheName();
            Object key = led.ce.getKey();
            Serializable obj = null;
            switch (led.command) {
                case UPDATE: {
                    LateralTCPListener.this.handlePut(led.ce);
                    break;
                }
                case REMOVE: {
                    ICacheElement test;
                    if (led.valHashCode != -1 && LateralTCPListener.this.getTcpLateralCacheAttributes().isFilterRemoveByHashCode() && (test = LateralTCPListener.this.getCache(cacheName).localGet(key)) != null) {
                        if (test.getVal().hashCode() == led.valHashCode) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Filtering detected identical hashCode [" + led.valHashCode + "], not issuing a remove for led " + led));
                            }
                            return;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Different hashcodes, in cache [" + test.getVal().hashCode() + "] sent [" + led.valHashCode + "]"));
                        }
                    }
                    LateralTCPListener.this.handleRemove(cacheName, key);
                    break;
                }
                case REMOVEALL: {
                    LateralTCPListener.this.handleRemoveAll(cacheName);
                    break;
                }
                case GET: {
                    obj = LateralTCPListener.this.handleGet(cacheName, key);
                    break;
                }
                case GET_MATCHING: {
                    obj = (Serializable)((Object)LateralTCPListener.this.handleGetMatching(cacheName, (String)key));
                    break;
                }
                case GET_KEYSET: {
                    obj = (Serializable)((Object)LateralTCPListener.this.handleGetKeySet(cacheName));
                    break;
                }
            }
            if (obj != null) {
                ObjectOutputStream oos = new ObjectOutputStream(this.socket.getOutputStream());
                oos.writeObject(obj);
                oos.flush();
            }
        }
    }

    public class ListenerThread
    extends Thread {
        private final ServerSocket serverSocket;

        public ListenerThread(ServerSocket serverSocket) {
            this.serverSocket = serverSocket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block23: {
                try {
                    while (true) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Waiting for clients to connect ");
                        }
                        Socket socket = null;
                        while (true) {
                            LateralTCPListener lateralTCPListener = LateralTCPListener.this;
                            synchronized (lateralTCPListener) {
                                if (LateralTCPListener.this.terminated) {
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)"Thread terminated, exiting gracefully");
                                    }
                                    break block23;
                                }
                            }
                            try {
                                socket = this.serverSocket.accept();
                            }
                            catch (SocketTimeoutException e) {
                                continue;
                            }
                            break;
                        }
                        if (socket != null && log.isDebugEnabled()) {
                            InetAddress inetAddress = socket.getInetAddress();
                            log.debug((Object)("Connected to client at " + inetAddress));
                        }
                        ConnectionHandler handler = new ConnectionHandler(socket);
                        LateralTCPListener.this.pooledExecutor.execute(handler);
                    }
                }
                catch (IOException e) {
                    log.error((Object)"Exception caught in TCP listener", (Throwable)e);
                }
                finally {
                    if (this.serverSocket != null) {
                        try {
                            this.serverSocket.close();
                        }
                        catch (IOException e) {
                            log.error((Object)"Exception caught closing socket", (Throwable)e);
                        }
                    }
                }
            }
        }
    }
}

