/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.lateral.socket.tcp;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.commons.jcs.auxiliary.lateral.LateralElementDescriptor;
import org.apache.commons.jcs.auxiliary.lateral.socket.tcp.behavior.ITCPLateralCacheAttributes;
import org.apache.commons.jcs.io.ObjectInputStreamClassLoaderAware;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LateralTCPSender {
    private static final Log log = LogFactory.getLog(LateralTCPSender.class);
    private ITCPLateralCacheAttributes tcpLateralCacheAttributes;
    private String remoteHost;
    private InetAddress address;
    private int port = 1111;
    private ObjectOutputStream oos;
    private Socket socket;
    private int sendCnt = 0;
    private final Object getLock = new int[0];

    public LateralTCPSender(ITCPLateralCacheAttributes lca) throws IOException {
        this.setTcpLateralCacheAttributes(lca);
        String p1 = lca.getTcpServer();
        if (p1 != null) {
            String h2 = p1.substring(0, p1.indexOf(":"));
            int po = Integer.parseInt(p1.substring(p1.indexOf(":") + 1));
            if (log.isDebugEnabled()) {
                log.debug((Object)("h2 = " + h2));
                log.debug((Object)("po = " + po));
            }
            if (h2.length() == 0) {
                throw new IOException("Cannot connect to invalid address [" + h2 + ":" + po + "]");
            }
            this.init(h2, po);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init(String host, int port) throws IOException {
        this.port = port;
        this.address = this.getAddressByName(host);
        this.setRemoteHost(host);
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)("Attempting connection to [" + this.address.getHostName() + "]"));
            }
            try {
                this.socket = new Socket();
                this.socket.connect(new InetSocketAddress(host, port), this.tcpLateralCacheAttributes.getOpenTimeOut());
            }
            catch (IOException ioe) {
                if (this.socket != null) {
                    this.socket.close();
                }
                throw new IOException("Cannot connect to " + host + ":" + port, ioe);
            }
            this.socket.setSoTimeout(this.tcpLateralCacheAttributes.getSocketTimeOut());
            LateralTCPSender ioe = this;
            synchronized (ioe) {
                this.oos = new ObjectOutputStream(this.socket.getOutputStream());
            }
        }
        catch (ConnectException e) {
            log.debug((Object)("Remote host [" + this.address.getHostName() + "] refused connection."));
            throw e;
        }
        catch (IOException e) {
            log.debug((Object)("Could not connect to [" + this.address.getHostName() + "]. Exception is " + e));
            throw e;
        }
    }

    private InetAddress getAddressByName(String host) throws IOException {
        try {
            return InetAddress.getByName(host);
        }
        catch (Exception e) {
            log.error((Object)("Could not find address of [" + host + "] "), (Throwable)e);
            throw new IOException("Could not find address of [" + host + "] " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> void send(LateralElementDescriptor<K, V> led) throws IOException {
        ++this.sendCnt;
        if (log.isInfoEnabled() && this.sendCnt % 100 == 0) {
            log.info((Object)("Send Count (port " + this.port + ") = " + this.sendCnt));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"sending LateralElementDescriptor");
        }
        if (led == null) {
            return;
        }
        if (this.address == null) {
            throw new IOException("No remote host is set for LateralTCPSender.");
        }
        if (this.oos != null) {
            Object object = this.getLock;
            synchronized (object) {
                try {
                    this.oos.writeUnshared(led);
                    this.oos.flush();
                }
                catch (IOException e) {
                    this.oos = null;
                    log.error((Object)("Detected problem with connection: " + e));
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Object sendAndReceive(LateralElementDescriptor<K, V> led) throws IOException {
        if (led == null) {
            return null;
        }
        if (this.address == null) {
            throw new IOException("No remote host is set for LateralTCPSender.");
        }
        Object response = null;
        if (this.oos != null) {
            Object object = this.getLock;
            synchronized (object) {
                try {
                    try {
                        if (this.socket.getInputStream().available() > 0) {
                            this.socket.getInputStream().read(new byte[this.socket.getInputStream().available()]);
                        }
                    }
                    catch (IOException ioe) {
                        log.error((Object)("Problem cleaning socket before send " + this.socket), (Throwable)ioe);
                        throw ioe;
                    }
                    this.oos.writeUnshared(led);
                    this.oos.flush();
                    try {
                        ObjectInputStreamClassLoaderAware ois = new ObjectInputStreamClassLoaderAware(this.socket.getInputStream(), null);
                        response = ois.readObject();
                    }
                    catch (IOException ioe) {
                        String message = "Could not open ObjectInputStream to " + this.socket;
                        message = message + " SoTimeout [" + this.socket.getSoTimeout() + "] Connected [" + this.socket.isConnected() + "]";
                        log.error((Object)message, (Throwable)ioe);
                        throw ioe;
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                }
                catch (IOException e) {
                    this.oos = null;
                    log.error((Object)("Detected problem with connection: " + e));
                    throw e;
                }
            }
        }
        return response;
    }

    public void dispose(String cache) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Dispose called for cache [" + cache + "]"));
        }
        this.oos.close();
    }

    public void setTcpLateralCacheAttributes(ITCPLateralCacheAttributes tcpLateralCacheAttributes) {
        this.tcpLateralCacheAttributes = tcpLateralCacheAttributes;
    }

    public ITCPLateralCacheAttributes getTcpLateralCacheAttributes() {
        return this.tcpLateralCacheAttributes;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }
}

