/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.commons.jcs.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheFactory;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheAttributes;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheManager;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheNoWait;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheNoWaitFacade;
import org.apache.commons.jcs.auxiliary.remote.server.behavior.RemoteType;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;

public class RemoteCacheFactory
implements AuxiliaryCacheFactory {
    private String name;
    private static final HashMap<String, RemoteCacheNoWaitFacade<?, ?>> facades = new HashMap();

    @Override
    public <K, V> AuxiliaryCache<K, V> createCache(AuxiliaryCacheAttributes iaca, ICompositeCacheManager cacheMgr, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        RemoteCacheAttributes rca = (RemoteCacheAttributes)iaca;
        ArrayList noWaits = new ArrayList();
        if (rca.getRemoteType() == RemoteType.LOCAL) {
            String failoverList;
            ArrayList<String> failovers = new ArrayList<String>();
            boolean primayDefined = false;
            if (rca.getRemoteHost() != null) {
                primayDefined = true;
                failovers.add(rca.getRemoteHost() + ":" + rca.getRemotePort());
                RemoteCacheManager rcm = RemoteCacheManager.getInstance(rca, cacheMgr, cacheEventLogger, elementSerializer);
                RemoteCacheNoWait ic = rcm.getCache(rca);
                noWaits.add(ic);
            }
            if ((failoverList = rca.getFailoverServers()) != null) {
                StringTokenizer fit = new StringTokenizer(failoverList, ",");
                int fCnt = 0;
                while (fit.hasMoreElements()) {
                    ++fCnt;
                    String server = (String)fit.nextElement();
                    failovers.add(server);
                    rca.setRemoteHost(server.substring(0, server.indexOf(":")));
                    rca.setRemotePort(Integer.parseInt(server.substring(server.indexOf(":") + 1)));
                    RemoteCacheManager rcm = RemoteCacheManager.getInstance(rca, cacheMgr, cacheEventLogger, elementSerializer);
                    if ((primayDefined || fCnt != 1) && noWaits.size() > 0) continue;
                    RemoteCacheNoWait ic = rcm.getCache(rca);
                    noWaits.add(ic);
                }
            }
            rca.setFailovers(failovers.toArray(new String[0]));
        } else if (rca.getRemoteType() == RemoteType.CLUSTER) {
            StringTokenizer it = new StringTokenizer(rca.getClusterServers(), ",");
            while (it.hasMoreElements()) {
                String server = (String)it.nextElement();
                rca.setRemoteHost(server.substring(0, server.indexOf(":")));
                rca.setRemotePort(Integer.parseInt(server.substring(server.indexOf(":") + 1)));
                RemoteCacheManager rcm = RemoteCacheManager.getInstance(rca, cacheMgr, cacheEventLogger, elementSerializer);
                rca.setRemoteType(RemoteType.CLUSTER);
                RemoteCacheNoWait ic = rcm.getCache(rca);
                noWaits.add(ic);
            }
        }
        RemoteCacheNoWait[] rcnwArray = noWaits.toArray(new RemoteCacheNoWait[0]);
        RemoteCacheNoWaitFacade rcnwf = new RemoteCacheNoWaitFacade(rcnwArray, rca, cacheMgr, cacheEventLogger, elementSerializer);
        RemoteCacheFactory.getFacades().put(rca.getCacheName(), rcnwf);
        return rcnwf;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public static HashMap<String, RemoteCacheNoWaitFacade<?, ?>> getFacades() {
        return facades;
    }
}

