/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import org.apache.commons.jcs.auxiliary.remote.AbstractRemoteCacheListener;
import org.apache.commons.jcs.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.commons.jcs.auxiliary.remote.behavior.IRemoteCacheConstants;
import org.apache.commons.jcs.auxiliary.remote.behavior.IRemoteCacheListener;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteCacheListener<K, V>
extends AbstractRemoteCacheListener<K, V>
implements IRemoteCacheConstants,
Serializable,
IRemoteCacheListener<K, V> {
    private static final long serialVersionUID = 25345252345322345L;
    private static final Log log = LogFactory.getLog(RemoteCacheListener.class);
    private boolean disposed = false;

    public RemoteCacheListener(IRemoteCacheAttributes irca, ICompositeCacheManager cacheMgr) {
        super(irca, cacheMgr);
        try {
            UnicastRemoteObject.exportObject((Remote)this, irca.getLocalPort());
        }
        catch (RemoteException ex) {
            log.error((Object)"Problem exporting object.", (Throwable)ex);
            throw new IllegalStateException(ex.getMessage());
        }
    }

    @Override
    public synchronized void dispose() throws IOException {
        if (!this.disposed) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Unexporting listener.");
            }
            try {
                UnicastRemoteObject.unexportObject(this, true);
            }
            catch (RemoteException ex) {
                log.error((Object)"Problem unexporting the listener.", (Throwable)ex);
                throw new IllegalStateException(ex.getMessage());
            }
            this.disposed = true;
        }
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("\n RemoteCacheListener: ");
        buf.append(super.toString());
        return buf.toString();
    }
}

