/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote;

import org.apache.commons.jcs.auxiliary.remote.AbstractRemoteCacheNoWaitFacade;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheAttributes;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheFailoverRunner;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheNoWait;
import org.apache.commons.jcs.auxiliary.remote.server.behavior.RemoteType;
import org.apache.commons.jcs.engine.CacheStatus;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteCacheNoWaitFacade<K, V>
extends AbstractRemoteCacheNoWaitFacade<K, V> {
    private static final Log log = LogFactory.getLog(RemoteCacheNoWaitFacade.class);

    public RemoteCacheNoWaitFacade(RemoteCacheNoWait<K, V>[] noWaits, RemoteCacheAttributes rca, ICompositeCacheManager cacheMgr, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        super(noWaits, rca, cacheMgr, cacheEventLogger, elementSerializer);
    }

    @Override
    protected void failover(int i) {
        if (log.isDebugEnabled()) {
            log.info((Object)("in failover for " + i));
        }
        if (this.getRemoteCacheAttributes().getRemoteType() == RemoteType.LOCAL) {
            if (this.noWaits[i].getStatus() == CacheStatus.ERROR) {
                RemoteCacheFailoverRunner runner = new RemoteCacheFailoverRunner(this, this.getCompositeCacheManager(), super.getCacheEventLogger(), super.getElementSerializer());
                runner.notifyError();
                Thread t = new Thread(runner);
                t.setDaemon(true);
                t.start();
                if (this.getCacheEventLogger() != null) {
                    this.getCacheEventLogger().logApplicationEvent("RemoteCacheNoWaitFacade", "InitiatedFailover", this.noWaits[i] + " was in error.");
                }
            } else if (log.isInfoEnabled()) {
                log.info((Object)"The noWait is not in error");
            }
        }
    }
}

