/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote;

import java.io.IOException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheManager;
import org.apache.commons.jcs.auxiliary.remote.behavior.IRemoteCacheObserver;
import org.apache.commons.jcs.engine.behavior.ICacheRestore;
import org.apache.commons.jcs.engine.behavior.ICacheServiceNonLocal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteCacheRestore
implements ICacheRestore {
    private static final Log log = LogFactory.getLog(RemoteCacheRestore.class);
    private final RemoteCacheManager remoteCacheManager;
    private boolean canFix = true;
    private Object remoteObj;

    public RemoteCacheRestore(RemoteCacheManager rcm) {
        this.remoteCacheManager = rcm;
    }

    @Override
    public boolean canFix() {
        if (!this.canFix) {
            return this.canFix;
        }
        String registry = "//" + this.remoteCacheManager.host + ":" + this.remoteCacheManager.port + "/" + this.remoteCacheManager.service;
        if (log.isInfoEnabled()) {
            log.info((Object)("looking up server [" + registry + "]"));
        }
        try {
            this.remoteObj = Naming.lookup(registry);
            if (log.isInfoEnabled()) {
                log.info((Object)("Found server " + this.remoteObj));
            }
        }
        catch (IOException e) {
            log.error((Object)("host=" + this.remoteCacheManager.host + "; port" + this.remoteCacheManager.port + "; service=" + this.remoteCacheManager.service));
            this.canFix = false;
        }
        catch (NotBoundException e) {
            log.error((Object)("host=" + this.remoteCacheManager.host + "; port" + this.remoteCacheManager.port + "; service=" + this.remoteCacheManager.service));
            this.canFix = false;
        }
        return this.canFix;
    }

    @Override
    public void fix() {
        if (!this.canFix) {
            return;
        }
        this.remoteCacheManager.fixCaches((ICacheServiceNonLocal)this.remoteObj, (IRemoteCacheObserver)this.remoteObj);
        if (log.isInfoEnabled()) {
            String msg = "Remote connection to //" + this.remoteCacheManager.host + ":" + this.remoteCacheManager.port + "/" + this.remoteCacheManager.service + " resumed.";
            this.remoteCacheManager.logApplicationEvent("RemoteCacheRestore", "fix", msg);
            log.info((Object)msg);
        }
    }
}

