/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote.http.client;

import java.io.IOException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.jcs.auxiliary.remote.http.client.RemoteHttpCacheAttributes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractHttpClient {
    private MultiThreadedHttpConnectionManager connectionManager;
    private HttpClient httpClient;
    private RemoteHttpCacheAttributes remoteHttpCacheAttributes;
    private static final Log log = LogFactory.getLog(AbstractHttpClient.class);

    public AbstractHttpClient(RemoteHttpCacheAttributes remoteHttpCacheAttributes) {
        this.setRemoteHttpCacheAttributes(remoteHttpCacheAttributes);
        this.setConnectionManager(new MultiThreadedHttpConnectionManager());
        this.setHttpClient(new HttpClient((HttpConnectionManager)this.getConnectionManager()));
        this.configureClient();
    }

    public void configureClient() {
        if (this.getRemoteHttpCacheAttributes().getMaxConnectionsPerHost() > 0) {
            this.getConnectionManager().getParams().setMaxTotalConnections(this.getRemoteHttpCacheAttributes().getMaxConnectionsPerHost());
        }
        this.getConnectionManager().getParams().setSoTimeout(this.getRemoteHttpCacheAttributes().getSocketTimeoutMillis());
        String httpVersion = this.getRemoteHttpCacheAttributes().getHttpVersion();
        if (httpVersion != null) {
            if ("1.1".equals(httpVersion)) {
                this.getHttpClient().getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
            } else if ("1.0".equals(httpVersion)) {
                this.getHttpClient().getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_0);
            } else {
                log.warn((Object)("Unrecognized value for 'httpVersion': [" + httpVersion + "]"));
            }
        }
        this.getConnectionManager().getParams().setConnectionTimeout(this.getRemoteHttpCacheAttributes().getConnectionTimeoutMillis());
        String cookiePolicy = "ignoreCookies";
        this.getHttpClient().getParams().setCookiePolicy(cookiePolicy);
    }

    protected final void doWebserviceCall(HttpMethod post) throws IOException {
        HttpState httpState = this.preProcessWebserviceCall(post);
        this.getHttpClient().executeMethod(null, post, httpState);
        this.postProcessWebserviceCall(post, httpState);
    }

    public abstract HttpState preProcessWebserviceCall(HttpMethod var1) throws IOException;

    public abstract void postProcessWebserviceCall(HttpMethod var1, HttpState var2) throws IOException;

    private HttpClient getHttpClient() {
        return this.httpClient;
    }

    private void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public MultiThreadedHttpConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public void setConnectionManager(MultiThreadedHttpConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void setRemoteHttpCacheAttributes(RemoteHttpCacheAttributes remoteHttpCacheAttributes) {
        this.remoteHttpCacheAttributes = remoteHttpCacheAttributes;
    }

    public RemoteHttpCacheAttributes getRemoteHttpCacheAttributes() {
        return this.remoteHttpCacheAttributes;
    }
}

