/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote.http.client;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheManager;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheNoWait;
import org.apache.commons.jcs.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.commons.jcs.auxiliary.remote.http.client.RemoteHttpCache;
import org.apache.commons.jcs.auxiliary.remote.http.client.RemoteHttpCacheAttributes;
import org.apache.commons.jcs.auxiliary.remote.http.client.RemoteHttpCacheClient;
import org.apache.commons.jcs.auxiliary.remote.http.client.RemoteHttpCacheMonitor;
import org.apache.commons.jcs.auxiliary.remote.http.client.RemoteHttpClientListener;
import org.apache.commons.jcs.auxiliary.remote.http.client.behavior.IRemoteHttpCacheClient;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.behavior.IShutdownObserver;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs.utils.config.OptionConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteHttpCacheManager
implements AuxiliaryCacheManager,
IShutdownObserver {
    private static final Log log = LogFactory.getLog(RemoteHttpCacheManager.class);
    private static RemoteHttpCacheManager instance;
    static final Map<String, RemoteCacheNoWait<?, ?>> caches;
    private IRemoteCacheAttributes remoteCacheAttributes;
    private final ICacheEventLogger cacheEventLogger;
    private final IElementSerializer elementSerializer;
    private final ICompositeCacheManager cacheMgr;
    private static RemoteHttpCacheMonitor monitor;

    private RemoteHttpCacheManager(ICompositeCacheManager cacheMgr, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        this.cacheMgr = cacheMgr;
        this.cacheEventLogger = cacheEventLogger;
        this.elementSerializer = elementSerializer;
        this.cacheMgr.registerShutdownObserver(this);
    }

    public IRemoteCacheAttributes getDefaultCattr() {
        return this.remoteCacheAttributes;
    }

    public static synchronized RemoteHttpCacheManager getInstance() {
        return instance;
    }

    public static synchronized RemoteHttpCacheManager getInstance(ICompositeCacheManager cacheMgr, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        if (instance == null) {
            instance = new RemoteHttpCacheManager(cacheMgr, cacheEventLogger, elementSerializer);
        }
        if (monitor == null && (monitor = RemoteHttpCacheMonitor.getInstance()) != null) {
            Thread t = new Thread(monitor);
            t.setDaemon(true);
            t.start();
        }
        return instance;
    }

    public <K, V> RemoteCacheNoWait<K, V> getCache(String cacheName) {
        RemoteHttpCacheAttributes ca = new RemoteHttpCacheAttributes();
        ca.setCacheName(cacheName);
        return this.getCache(ca);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> RemoteCacheNoWait<K, V> getCache(RemoteHttpCacheAttributes cattr) {
        RemoteCacheNoWait<Object, Object> remoteCacheNoWait = null;
        Map<String, RemoteCacheNoWait<?, ?>> map = caches;
        synchronized (map) {
            RemoteCacheNoWait<?, ?> remoteCacheNoWait2 = caches.get(cattr.getCacheName() + cattr.getUrl());
            remoteCacheNoWait = remoteCacheNoWait2;
            if (remoteCacheNoWait == null) {
                RemoteHttpClientListener listener = new RemoteHttpClientListener(cattr, this.cacheMgr);
                IRemoteHttpCacheClient<K, V> remoteService = this.createRemoteHttpCacheClientForAttributes(cattr);
                RemoteHttpCache<K, V> remoteCacheClient = new RemoteHttpCache<K, V>(cattr, remoteService, listener);
                remoteCacheClient.setCacheEventLogger(this.cacheEventLogger);
                remoteCacheClient.setElementSerializer(this.elementSerializer);
                remoteCacheNoWait = new RemoteCacheNoWait<K, V>(remoteCacheClient);
                remoteCacheNoWait.setCacheEventLogger(this.cacheEventLogger);
                remoteCacheNoWait.setElementSerializer(this.elementSerializer);
                caches.put(cattr.getCacheName() + cattr.getUrl(), remoteCacheNoWait);
            }
        }
        return remoteCacheNoWait;
    }

    protected <K, V> IRemoteHttpCacheClient<K, V> createRemoteHttpCacheClientForAttributes(RemoteHttpCacheAttributes cattr) {
        RemoteHttpCacheClient client = OptionConverter.instantiateByClassName(cattr.getRemoteHttpClientClassName(), null);
        if (client == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Creating the default client.");
            }
            client = new RemoteHttpCacheClient();
        }
        client.initialize(cattr);
        return client;
    }

    public String getStats() {
        StringBuilder stats = new StringBuilder();
        for (RemoteCacheNoWait<?, ?> c : caches.values()) {
            if (c == null) continue;
            stats.append(c.getCacheName());
        }
        return stats.toString();
    }

    @Override
    public void shutdown() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Observed shutdown request.");
        }
    }

    protected void logApplicationEvent(String source, String eventName, String optionalDetails) {
        if (this.cacheEventLogger != null) {
            this.cacheEventLogger.logApplicationEvent(source, eventName, optionalDetails);
        }
    }

    static {
        caches = new HashMap();
    }
}

