/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote.http.client;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.jcs.auxiliary.remote.http.client.RemoteHttpCache;
import org.apache.commons.jcs.auxiliary.remote.http.client.RemoteHttpCacheAttributes;
import org.apache.commons.jcs.auxiliary.remote.http.client.RemoteHttpCacheManager;
import org.apache.commons.jcs.auxiliary.remote.http.client.behavior.IRemoteHttpCacheClient;
import org.apache.commons.jcs.engine.CacheStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteHttpCacheMonitor
implements Runnable {
    private static final Log log = LogFactory.getLog(RemoteHttpCacheMonitor.class);
    private static RemoteHttpCacheMonitor instance;
    private static long idlePeriod;
    private final Set<RemoteHttpCache<?, ?>> remoteHttpCaches = new HashSet();
    private boolean alright = true;
    static final int TIME = 0;
    static final int ERROR = 1;
    static int mode;

    public static void setIdlePeriod(long idlePeriod) {
        if (idlePeriod > RemoteHttpCacheMonitor.idlePeriod) {
            RemoteHttpCacheMonitor.idlePeriod = idlePeriod;
        }
    }

    private RemoteHttpCacheMonitor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RemoteHttpCacheMonitor getInstance() {
        Class<RemoteHttpCacheMonitor> clazz = RemoteHttpCacheMonitor.class;
        synchronized (RemoteHttpCacheMonitor.class) {
            if (instance == null) {
                instance = new RemoteHttpCacheMonitor();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyError(RemoteHttpCache<?, ?> remoteCache) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Notified of an error. " + remoteCache));
        }
        this.bad();
        RemoteHttpCacheMonitor remoteHttpCacheMonitor = this;
        synchronized (remoteHttpCacheMonitor) {
            this.remoteHttpCaches.add(remoteCache);
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Monitoring daemon started");
        }
        block15: while (true) {
            if (mode == 1) {
                RemoteHttpCacheMonitor remoteHttpCacheMonitor = this;
                synchronized (remoteHttpCacheMonitor) {
                    if (this.alright) {
                        try {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"FAILURE DRIVEN MODE: cache monitor waiting for error");
                            }
                            this.wait();
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                    }
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("TIME DRIVEN MODE: cache monitor sleeping for " + idlePeriod));
            }
            try {
                Thread.sleep(idlePeriod);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            RemoteHttpCacheMonitor ex = this;
            synchronized (ex) {
                this.alright = true;
            }
            HashSet remoteCachesToExamine = new HashSet();
            RemoteHttpCacheMonitor ignore = this;
            synchronized (ignore) {
                for (RemoteHttpCache<?, ?> remoteCache : this.remoteHttpCaches) {
                    remoteCachesToExamine.add(remoteCache);
                }
            }
            Iterator i$ = remoteCachesToExamine.iterator();
            while (true) {
                if (!i$.hasNext()) continue block15;
                RemoteHttpCache remoteCache = (RemoteHttpCache)i$.next();
                try {
                    if (remoteCache.getStatus() != CacheStatus.ERROR) continue;
                    RemoteHttpCacheAttributes attributes = remoteCache.getRemoteHttpCacheAttributes();
                    IRemoteHttpCacheClient remoteService = RemoteHttpCacheManager.getInstance().createRemoteHttpCacheClientForAttributes(attributes);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Performing Alive check on service " + remoteService));
                    }
                    if (remoteService.isAlive()) {
                        remoteCache.fixCache(remoteService);
                        continue block15;
                    }
                    this.bad();
                    continue block15;
                }
                catch (Exception ex2) {
                    this.bad();
                    log.error((Object)ex2);
                    continue;
                }
                break;
            }
        }
    }

    private synchronized void bad() {
        this.alright = false;
    }

    static {
        idlePeriod = 3000L;
        mode = 1;
    }
}

