/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote.http.server;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jcs.auxiliary.remote.http.server.RemoteHttpCacheService;
import org.apache.commons.jcs.auxiliary.remote.http.server.RemoteHttpCacheSeviceFactory;
import org.apache.commons.jcs.auxiliary.remote.value.RemoteCacheRequest;
import org.apache.commons.jcs.auxiliary.remote.value.RemoteCacheResponse;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICacheServiceNonLocal;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteCacheServiceAdaptor<K extends Serializable, V extends Serializable> {
    private static final Log log = LogFactory.getLog(RemoteCacheServiceAdaptor.class);
    private ICacheServiceNonLocal<K, V> remoteCacheService;

    protected RemoteCacheServiceAdaptor() {
    }

    public RemoteCacheServiceAdaptor(ICompositeCacheManager cacheManager) {
        RemoteHttpCacheService rcs = RemoteHttpCacheSeviceFactory.createRemoteHttpCacheService(cacheManager);
        this.setRemoteCacheService(rcs);
    }

    public <T> RemoteCacheResponse<T> processRequest(RemoteCacheRequest<K, V> request) {
        RemoteCacheResponse<Object> response = new RemoteCacheResponse<Object>();
        if (request == null) {
            String message = "The request is null. Cannot process";
            log.warn((Object)message);
            response.setSuccess(false);
            response.setErrorMessage(message);
        } else {
            try {
                switch (request.getRequestType()) {
                    case GET: {
                        ICacheElement<K, V> element = this.getRemoteCacheService().get(request.getCacheName(), request.getKey(), request.getRequesterId());
                        response.setPayload(element);
                        break;
                    }
                    case GET_MULTIPLE: {
                        Map<K, ICacheElement<K, V>> elementMap = this.getRemoteCacheService().getMultiple(request.getCacheName(), request.getKeySet(), request.getRequesterId());
                        if (elementMap != null) {
                            HashMap<K, ICacheElement<K, V>> map = new HashMap<K, ICacheElement<K, V>>();
                            map.putAll(elementMap);
                            response.setPayload(map);
                        }
                        break;
                    }
                    case GET_MATCHING: {
                        Map<K, ICacheElement<K, V>> elementMapMatching = this.getRemoteCacheService().getMatching(request.getCacheName(), request.getPattern(), request.getRequesterId());
                        if (elementMapMatching != null) {
                            HashMap<K, ICacheElement<K, V>> map = new HashMap<K, ICacheElement<K, V>>();
                            map.putAll(elementMapMatching);
                            response.setPayload(map);
                        }
                        break;
                    }
                    case REMOVE: {
                        this.getRemoteCacheService().remove(request.getCacheName(), request.getKey(), request.getRequesterId());
                        break;
                    }
                    case REMOVE_ALL: {
                        this.getRemoteCacheService().removeAll(request.getCacheName(), request.getRequesterId());
                        break;
                    }
                    case UPDATE: {
                        this.getRemoteCacheService().update(request.getCacheElement(), request.getRequesterId());
                        break;
                    }
                    case ALIVE_CHECK: {
                        response.setSuccess(true);
                        break;
                    }
                    case DISPOSE: {
                        response.setSuccess(true);
                        break;
                    }
                    case GET_KEYSET: {
                        Set<K> keys = this.getRemoteCacheService().getKeySet(request.getCacheName());
                        response.setPayload(keys);
                        break;
                    }
                    default: {
                        String message = "Unknown event type.  Cannot process " + request;
                        log.warn((Object)message);
                        response.setSuccess(false);
                        response.setErrorMessage(message);
                        break;
                    }
                }
            }
            catch (IOException e) {
                String message = "Problem processing request. " + request + " Error: " + e.getMessage();
                log.error((Object)message, (Throwable)e);
                response.setSuccess(false);
                response.setErrorMessage(message);
            }
        }
        return response;
    }

    public void setRemoteCacheService(ICacheServiceNonLocal<K, V> remoteHttpCacheService) {
        this.remoteCacheService = remoteHttpCacheService;
    }

    public ICacheServiceNonLocal<K, V> getRemoteCacheService() {
        return this.remoteCacheService;
    }
}

