/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote.http.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.jcs.access.exception.CacheException;
import org.apache.commons.jcs.auxiliary.remote.http.server.RemoteCacheServiceAdaptor;
import org.apache.commons.jcs.auxiliary.remote.value.RemoteCacheRequest;
import org.apache.commons.jcs.auxiliary.remote.value.RemoteCacheResponse;
import org.apache.commons.jcs.engine.control.CompositeCacheManager;
import org.apache.commons.jcs.io.ObjectInputStreamClassLoaderAware;
import org.apache.commons.jcs.utils.serialization.StandardSerializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteHttpCacheServlet
extends HttpServlet {
    private static final long serialVersionUID = 8752849397531933346L;
    private static final Log log = LogFactory.getLog(RemoteHttpCacheServlet.class);
    private static CompositeCacheManager cacheMgr;
    private RemoteCacheServiceAdaptor<Serializable, Serializable> remoteHttpCacheServiceAdaptor;
    private final StandardSerializer serializer = new StandardSerializer();
    private int serviceCalls = 0;
    private final int logInterval = 100;

    public void init(ServletConfig config) throws ServletException {
        try {
            this.ensureCacheManager();
        }
        catch (CacheException e) {
            throw new ServletException((Throwable)e);
        }
        this.setRemoteHttpCacheServiceAdaptor(new RemoteCacheServiceAdaptor<Serializable, Serializable>(cacheMgr));
        super.init(config);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.incrementServiceCallCount();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Servicing a request. " + request));
        }
        RemoteCacheRequest<Serializable, Serializable> remoteRequest = this.readRequest(request);
        RemoteCacheResponse<Serializable> cacheResponse = this.getRemoteHttpCacheServiceAdaptor().processRequest(remoteRequest);
        this.writeResponse(response, cacheResponse);
    }

    protected RemoteCacheRequest<Serializable, Serializable> readRequest(HttpServletRequest request) {
        RemoteCacheRequest<Serializable, Serializable> remoteRequest = null;
        try {
            ServletInputStream inputStream = request.getInputStream();
            if (log.isDebugEnabled()) {
                log.debug((Object)"After getting input stream and before reading it");
            }
            remoteRequest = this.readRequestFromStream((InputStream)inputStream);
        }
        catch (Exception e) {
            log.error((Object)"Could not get a RemoteHttpCacheRequest object from the input stream.", (Throwable)e);
        }
        return remoteRequest;
    }

    protected RemoteCacheRequest<Serializable, Serializable> readRequestFromStream(InputStream inputStream) throws IOException, ClassNotFoundException {
        ObjectInputStreamClassLoaderAware ois = new ObjectInputStreamClassLoaderAware(inputStream, null);
        RemoteCacheRequest remoteRequest = (RemoteCacheRequest)ois.readObject();
        ois.close();
        return remoteRequest;
    }

    protected void writeResponse(HttpServletResponse response, RemoteCacheResponse<Serializable> cacheResponse) {
        try {
            response.setContentType("application/octet-stream");
            byte[] responseAsByteAray = this.serializer.serialize(cacheResponse);
            response.setContentLength(responseAsByteAray.length);
            ServletOutputStream outputStream = response.getOutputStream();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Opened output stream.  Response size: " + responseAsByteAray.length));
            }
            outputStream.write(responseAsByteAray);
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception e) {
            log.error((Object)("Problem writing response. " + cacheResponse), (Throwable)e);
        }
    }

    private void incrementServiceCallCount() {
        ++this.serviceCalls;
        if (log.isInfoEnabled() && this.serviceCalls % 100 == 0) {
            log.info((Object)("serviceCalls = " + this.serviceCalls));
        }
    }

    protected synchronized void ensureCacheManager() throws CacheException {
        if (cacheMgr == null || !cacheMgr.isInitialized()) {
            cacheMgr = CompositeCacheManager.getInstance();
        }
    }

    public void destroy() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Servlet Destroyed, shutting down JCS.");
        }
        cacheMgr.shutDown();
    }

    public String getServletInfo() {
        return "RemoteHttpCacheServlet";
    }

    public void setRemoteHttpCacheServiceAdaptor(RemoteCacheServiceAdaptor<Serializable, Serializable> remoteHttpCacheProcessor) {
        this.remoteHttpCacheServiceAdaptor = remoteHttpCacheProcessor;
    }

    public RemoteCacheServiceAdaptor<Serializable, Serializable> getRemoteHttpCacheServiceAdaptor() {
        return this.remoteHttpCacheServiceAdaptor;
    }
}

