/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote.http.server;

import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheConfigurator;
import org.apache.commons.jcs.auxiliary.remote.http.server.RemoteHttpCacheServerAttributes;
import org.apache.commons.jcs.auxiliary.remote.http.server.RemoteHttpCacheService;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs.utils.config.PropertySetter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteHttpCacheSeviceFactory {
    private static final Log log = LogFactory.getLog(RemoteHttpCacheSeviceFactory.class);

    public static <K extends Serializable, V extends Serializable> RemoteHttpCacheService<K, V> createRemoteHttpCacheService(ICompositeCacheManager cacheManager) {
        Properties props = cacheManager.getConfigurationProperties();
        ICacheEventLogger cacheEventLogger = RemoteHttpCacheSeviceFactory.configureCacheEventLogger(props);
        RemoteHttpCacheServerAttributes attributes = RemoteHttpCacheSeviceFactory.configureRemoteHttpCacheServerAttributes(props);
        RemoteHttpCacheService service = new RemoteHttpCacheService(cacheManager, attributes, cacheEventLogger);
        if (log.isInfoEnabled()) {
            log.info((Object)("Created new RemoteHttpCacheService " + service));
        }
        return service;
    }

    protected static ICacheEventLogger configureCacheEventLogger(Properties props) {
        ICacheEventLogger cacheEventLogger = AuxiliaryCacheConfigurator.parseCacheEventLogger(props, "jcs.remotehttpcache");
        return cacheEventLogger;
    }

    protected static RemoteHttpCacheServerAttributes configureRemoteHttpCacheServerAttributes(Properties prop) {
        RemoteHttpCacheServerAttributes rcsa = new RemoteHttpCacheServerAttributes();
        PropertySetter.setProperties(rcsa, prop, "jcs.remotehttpcache.serverattributes.");
        return rcsa;
    }
}

