/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote.server;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheConfigurator;
import org.apache.commons.jcs.auxiliary.remote.RemoteUtils;
import org.apache.commons.jcs.auxiliary.remote.behavior.IRemoteCacheConstants;
import org.apache.commons.jcs.auxiliary.remote.server.RegistryKeepAliveRunner;
import org.apache.commons.jcs.auxiliary.remote.server.RemoteCacheServer;
import org.apache.commons.jcs.auxiliary.remote.server.RemoteCacheServerAttributes;
import org.apache.commons.jcs.engine.behavior.ICacheServiceAdmin;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs.utils.config.OptionConverter;
import org.apache.commons.jcs.utils.config.PropertySetter;
import org.apache.commons.jcs.utils.threadpool.DaemonThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteCacheServerFactory
implements IRemoteCacheConstants {
    private static final Log log = LogFactory.getLog(RemoteCacheServerFactory.class);
    private static RemoteCacheServer<? extends Serializable, ? extends Serializable> remoteCacheServer;
    private static String serviceName;
    private static ScheduledExecutorService keepAliveDaemon;
    private static Registry registry;

    private RemoteCacheServerFactory() {
    }

    public static <K, V> RemoteCacheServer<K, V> getRemoteCacheServer() {
        return remoteCacheServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startup(String host, int port, String propFile) throws IOException {
        if (remoteCacheServer != null) {
            throw new IllegalArgumentException("Server already started.");
        }
        Class<RemoteCacheServer> clazz = RemoteCacheServer.class;
        synchronized (RemoteCacheServer.class) {
            if (remoteCacheServer != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("ConfigFileName = [" + propFile + "]"));
            }
            Properties props = RemoteUtils.loadProps(propFile);
            RemoteCacheServerFactory.startup(host, port, props);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startup(String host, int port, Properties props) throws IOException {
        if (remoteCacheServer != null) {
            throw new IllegalArgumentException("Server already started.");
        }
        Class<RemoteCacheServer> clazz = RemoteCacheServer.class;
        synchronized (RemoteCacheServer.class) {
            if (remoteCacheServer != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            if (host == null) {
                host = "";
            }
            RemoteCacheServerAttributes rcsa = RemoteCacheServerFactory.configureRemoteCacheServerAttributes(props);
            rcsa.setRemotePort(port);
            rcsa.setRemoteHost(host);
            if (log.isInfoEnabled()) {
                log.info((Object)("Creating server with these attributes: " + rcsa));
            }
            RemoteCacheServerFactory.setServiceName(rcsa.getRemoteServiceName());
            RMISocketFactory customRMISocketFactory = RemoteCacheServerFactory.configureObjectSpecificCustomFactory(props);
            RemoteUtils.configureGlobalCustomSocketFactory(rcsa.getRmiSocketFactoryTimeoutMillis());
            ICacheEventLogger cacheEventLogger = RemoteCacheServerFactory.configureCacheEventLogger(props);
            remoteCacheServer = customRMISocketFactory != null ? new RemoteCacheServer(rcsa, customRMISocketFactory) : new RemoteCacheServer(rcsa);
            remoteCacheServer.setCacheEventLogger(cacheEventLogger);
            if (rcsa.isStartRegistry()) {
                registry = RemoteUtils.createRegistry(port);
            }
            RemoteCacheServerFactory.registerServer(RemoteUtils.getNamingURL(host, port, serviceName), remoteCacheServer);
            if (rcsa.isUseRegistryKeepAlive()) {
                if (keepAliveDaemon == null) {
                    keepAliveDaemon = Executors.newScheduledThreadPool(1, new DaemonThreadFactory("JCS-RemoteCacheServerFactory-"));
                }
                RegistryKeepAliveRunner runner = new RegistryKeepAliveRunner(host, port, serviceName);
                runner.setCacheEventLogger(cacheEventLogger);
                keepAliveDaemon.scheduleAtFixedRate(runner, 0L, rcsa.getRegistryKeepAliveDelayMillis(), TimeUnit.MILLISECONDS);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    protected static ICacheEventLogger configureCacheEventLogger(Properties props) {
        ICacheEventLogger cacheEventLogger = AuxiliaryCacheConfigurator.parseCacheEventLogger(props, "jcs.remotecache");
        if (cacheEventLogger == null) {
            cacheEventLogger = AuxiliaryCacheConfigurator.parseCacheEventLogger(props, "remote");
        }
        return cacheEventLogger;
    }

    protected static RMISocketFactory configureObjectSpecificCustomFactory(Properties props) {
        RMISocketFactory customRMISocketFactory = OptionConverter.instantiateByKey(props, "jcs.remotecache.customrmisocketfactory", null);
        if (customRMISocketFactory != null) {
            PropertySetter.setProperties(customRMISocketFactory, props, "jcs.remotecache.customrmisocketfactory.");
            if (log.isInfoEnabled()) {
                log.info((Object)("Will use server specific custom socket factory. " + customRMISocketFactory));
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)"No server specific custom socket factory defined.");
        }
        return customRMISocketFactory;
    }

    protected static void registerServer(String namingURL, Remote server) throws RemoteException {
        if (server == null) {
            throw new RemoteException("Cannot register the server until it is created.");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Binding server to " + namingURL));
        }
        try {
            Naming.rebind(namingURL, server);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex.getMessage() + "; url=" + namingURL);
        }
    }

    protected static RemoteCacheServerAttributes configureRemoteCacheServerAttributes(Properties prop) {
        RemoteCacheServerAttributes rcsa = new RemoteCacheServerAttributes();
        PropertySetter.setProperties(rcsa, prop, "jcs.remotecache.serverattributes.");
        RemoteCacheServerFactory.configureManuallyIfValuesArePresent(prop, rcsa);
        return rcsa;
    }

    private static void configureManuallyIfValuesArePresent(Properties prop, RemoteCacheServerAttributes rcsa) {
        String acgStr;
        String lccStr;
        String socketTimeoutMillisStr;
        String servicePortStr = prop.getProperty("remote.cache.service.port");
        if (servicePortStr != null) {
            try {
                int servicePort = Integer.parseInt(servicePortStr);
                rcsa.setServicePort(servicePort);
                log.debug((Object)("Remote cache service uses port number " + servicePort + "."));
            }
            catch (NumberFormatException ignore) {
                log.debug((Object)"Remote cache service port property remote.cache.service.port not specified.  An anonymous port will be used.");
            }
        }
        if ((socketTimeoutMillisStr = prop.getProperty("remote.cache.rmiSocketFactoryTimeoutMillis")) != null) {
            try {
                int rmiSocketFactoryTimeoutMillis = Integer.parseInt(socketTimeoutMillisStr);
                rcsa.setRmiSocketFactoryTimeoutMillis(rmiSocketFactoryTimeoutMillis);
                log.debug((Object)("Remote cache socket timeout " + rmiSocketFactoryTimeoutMillis + "ms."));
            }
            catch (NumberFormatException ignore) {
                log.debug((Object)"Remote cache socket timeout property remote.cache.rmiSocketFactoryTimeoutMillis not specified.  The default will be used.");
            }
        }
        if ((lccStr = prop.getProperty("remote.cluster.LocalClusterConsistency")) != null) {
            boolean lcc = Boolean.valueOf(lccStr);
            rcsa.setLocalClusterConsistency(lcc);
        }
        if ((acgStr = prop.getProperty("remote.cluster.AllowClusterGet")) != null) {
            boolean acg = Boolean.valueOf(acgStr);
            rcsa.setAllowClusterGet(acg);
        }
        rcsa.setRemoteServiceName(prop.getProperty("remote.cache.service.name", REMOTE_CACHE_SERVICE_VAL).trim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void shutdownImpl(String host, int port) throws IOException {
        Class<RemoteCacheServer> clazz = RemoteCacheServer.class;
        synchronized (RemoteCacheServer.class) {
            if (remoteCacheServer == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            log.info((Object)("Unbinding host=" + host + ", port=" + port + ", serviceName=" + RemoteCacheServerFactory.getServiceName()));
            try {
                Naming.unbind(RemoteUtils.getNamingURL(host, port, RemoteCacheServerFactory.getServiceName()));
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException(ex.getMessage() + "; host=" + host + ", port=" + port + ", serviceName=" + RemoteCacheServerFactory.getServiceName());
            }
            catch (NotBoundException notBoundException) {
                // empty catch block
            }
            remoteCacheServer.release();
            remoteCacheServer = null;
            if (keepAliveDaemon != null) {
                keepAliveDaemon.shutdownNow();
                keepAliveDaemon = null;
            }
            if (registry != null) {
                UnicastRemoteObject.unexportObject(registry, true);
                registry = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static void main(String[] args) throws Exception {
        String host;
        ICacheServiceAdmin admin;
        Remote obj;
        String registry;
        int port;
        Properties prop = args.length > 0 ? RemoteUtils.loadProps(args[args.length - 1]) : new Properties();
        try {
            port = Integer.parseInt(prop.getProperty("registry.port"));
        }
        catch (NumberFormatException ex) {
            port = 1099;
        }
        if (args.length > 0 && args[0].toLowerCase().indexOf("-shutdown") != -1) {
            String remoteServiceName = prop.getProperty("remote.cache.service.name", REMOTE_CACHE_SERVICE_VAL).trim();
            registry = RemoteUtils.getNamingURL("", port, remoteServiceName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("looking up server " + registry));
            }
            obj = Naming.lookup(registry);
            if (log.isDebugEnabled()) {
                log.debug((Object)"server found");
            }
            admin = (ICacheServiceAdmin)((Object)obj);
            try {
                admin.shutdown();
            }
            catch (Exception ex) {
                log.error((Object)"Problem calling shutdown.", (Throwable)ex);
            }
            log.debug((Object)"done.");
            System.exit(0);
        }
        if (args.length > 0 && args[0].toLowerCase().indexOf("-stats") != -1) {
            log.debug((Object)"getting cache stats");
            try {
                String sz = prop.getProperty("remote.cache.service.name", REMOTE_CACHE_SERVICE_VAL).trim();
                registry = RemoteUtils.getNamingURL("", port, sz);
                log.debug((Object)("looking up server " + registry));
                obj = Naming.lookup(registry);
                log.debug((Object)"server found");
                log.debug((Object)("obj = " + obj));
                admin = (ICacheServiceAdmin)((Object)obj);
                try {
                    log.debug((Object)admin.getStats());
                }
                catch (Exception es) {
                    log.error((Object)es);
                }
            }
            catch (Exception ex) {
                log.error((Object)"Problem getting stats.", (Throwable)ex);
            }
            log.debug((Object)"done.");
            System.exit(0);
        }
        if ((host = prop.getProperty("registry.host")) == null || host.trim().equals("") || host.trim().equals("localhost")) {
            log.debug((Object)"main> creating registry on the localhost");
            RemoteUtils.createRegistry(port);
        }
        log.debug((Object)"main> starting up RemoteCacheServer");
        RemoteCacheServerFactory.startup(host, port, args.length > 0 ? args[0] : null);
        log.debug((Object)"main> done");
    }

    protected static void setServiceName(String serviceName) {
        RemoteCacheServerFactory.serviceName = serviceName;
    }

    protected static String getServiceName() {
        return serviceName;
    }

    static {
        serviceName = IRemoteCacheConstants.REMOTE_CACHE_SERVICE_VAL;
        registry = null;
    }
}

