/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote.util;

import java.util.Set;
import org.apache.commons.jcs.auxiliary.remote.value.RemoteCacheRequest;
import org.apache.commons.jcs.auxiliary.remote.value.RemoteRequestType;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteCacheRequestFactory {
    private static final Log log = LogFactory.getLog(RemoteCacheRequestFactory.class);

    public static <K, V> RemoteCacheRequest<K, V> createGetRequest(String cacheName, K key, long requesterId) {
        RemoteCacheRequest request = new RemoteCacheRequest();
        request.setCacheName(cacheName);
        request.setKey(key);
        request.setRequesterId(requesterId);
        request.setRequestType(RemoteRequestType.GET);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created: " + request));
        }
        return request;
    }

    public static <K, V> RemoteCacheRequest<K, V> createGetMatchingRequest(String cacheName, String pattern, long requesterId) {
        RemoteCacheRequest request = new RemoteCacheRequest();
        request.setCacheName(cacheName);
        request.setPattern(pattern);
        request.setRequesterId(requesterId);
        request.setRequestType(RemoteRequestType.GET_MATCHING);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created: " + request));
        }
        return request;
    }

    public static <K, V> RemoteCacheRequest<K, V> createGetMultipleRequest(String cacheName, Set<K> keys, long requesterId) {
        RemoteCacheRequest request = new RemoteCacheRequest();
        request.setCacheName(cacheName);
        request.setKeySet(keys);
        request.setRequesterId(requesterId);
        request.setRequestType(RemoteRequestType.GET_MULTIPLE);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created: " + request));
        }
        return request;
    }

    public static <K, V> RemoteCacheRequest<K, V> createRemoveRequest(String cacheName, K key, long requesterId) {
        RemoteCacheRequest request = new RemoteCacheRequest();
        request.setCacheName(cacheName);
        request.setKey(key);
        request.setRequesterId(requesterId);
        request.setRequestType(RemoteRequestType.REMOVE);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created: " + request));
        }
        return request;
    }

    public static RemoteCacheRequest<String, String> createGetKeySetRequest(String cacheName, long requesterId) {
        RemoteCacheRequest<String, String> request = new RemoteCacheRequest<String, String>();
        request.setCacheName(cacheName);
        request.setKey(cacheName);
        request.setRequesterId(requesterId);
        request.setRequestType(RemoteRequestType.GET_KEYSET);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created: " + request));
        }
        return request;
    }

    public static <K, V> RemoteCacheRequest<K, V> createRemoveAllRequest(String cacheName, long requesterId) {
        RemoteCacheRequest request = new RemoteCacheRequest();
        request.setCacheName(cacheName);
        request.setRequesterId(requesterId);
        request.setRequestType(RemoteRequestType.REMOVE_ALL);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created: " + request));
        }
        return request;
    }

    public static <K, V> RemoteCacheRequest<K, V> createDisposeRequest(String cacheName, long requesterId) {
        RemoteCacheRequest request = new RemoteCacheRequest();
        request.setCacheName(cacheName);
        request.setRequesterId(requesterId);
        request.setRequestType(RemoteRequestType.DISPOSE);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created: " + request));
        }
        return request;
    }

    public static <K, V> RemoteCacheRequest<K, V> createUpdateRequest(ICacheElement<K, V> cacheElement, long requesterId) {
        RemoteCacheRequest<K, V> request = new RemoteCacheRequest<K, V>();
        if (cacheElement != null) {
            request.setCacheName(cacheElement.getCacheName());
            request.setCacheElement(cacheElement);
            request.setKey(cacheElement.getKey());
        } else {
            log.error((Object)"Can't create a proper update request for a null cache element.");
        }
        request.setRequesterId(requesterId);
        request.setRequestType(RemoteRequestType.UPDATE);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created: " + request));
        }
        return request;
    }

    public static <K, V> RemoteCacheRequest<K, V> createAliveCheckRequest(long requesterId) {
        RemoteCacheRequest request = new RemoteCacheRequest();
        request.setRequesterId(requesterId);
        request.setRequestType(RemoteRequestType.ALIVE_CHECK);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created: " + request));
        }
        return request;
    }
}

