/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine.control;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.jcs.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheConfigurator;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheFactory;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs.engine.behavior.IElementAttributes;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.behavior.IRequireScheduler;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.jcs.engine.control.CompositeCacheManager;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs.engine.match.KeyMatcherPatternImpl;
import org.apache.commons.jcs.engine.match.behavior.IKeyMatcher;
import org.apache.commons.jcs.utils.config.OptionConverter;
import org.apache.commons.jcs.utils.config.PropertySetter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompositeCacheConfigurator {
    private static final Log log = LogFactory.getLog(CompositeCacheConfigurator.class);
    static final String DEFAULT_REGION = "jcs.default";
    static final String REGION_PREFIX = "jcs.region.";
    static final String SYSTEM_REGION_PREFIX = "jcs.system.";
    static final String AUXILIARY_PREFIX = "jcs.auxiliary.";
    static final String ATTRIBUTE_PREFIX = ".attributes";
    static final String CACHE_ATTRIBUTE_PREFIX = ".cacheattributes";
    static final String ELEMENT_ATTRIBUTE_PREFIX = ".elementattributes";
    public static final String KEY_MATCHER_PREFIX = ".keymatcher";
    private final CompositeCacheManager compositeCacheManager;

    public CompositeCacheConfigurator(CompositeCacheManager ccMgr) {
        this.compositeCacheManager = ccMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doConfigure(String configFileName) {
        Properties props = new Properties();
        FileInputStream istream = null;
        try {
            istream = new FileInputStream(configFileName);
            props.load(istream);
        }
        catch (IOException e) {
            log.error((Object)("Could not read configuration file, ignored: " + configFileName), (Throwable)e);
            return;
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException e) {
                    log.error((Object)("Could not close configuration file " + configFileName), (Throwable)e);
                }
            }
        }
        this.doConfigure(props);
    }

    public void doConfigure(Properties properties) {
        long start = System.currentTimeMillis();
        this.compositeCacheManager.setConfigurationProperties(properties);
        this.setDefaultAuxValues(properties);
        this.setDefaultCompositeCacheAttributes(properties);
        this.setDefaultElementAttributes(properties);
        this.parseSystemRegions(properties);
        this.parseRegions(properties);
        long end = System.currentTimeMillis();
        if (log.isInfoEnabled()) {
            log.info((Object)("Finished configuration in " + (end - start) + " ms."));
        }
    }

    protected void setDefaultAuxValues(Properties props) {
        String value = OptionConverter.findAndSubst(DEFAULT_REGION, props);
        this.compositeCacheManager.setDefaultAuxValues(value);
        if (log.isInfoEnabled()) {
            log.info((Object)("Setting default auxiliaries to " + value));
        }
    }

    protected void setDefaultCompositeCacheAttributes(Properties props) {
        ICompositeCacheAttributes icca = this.parseCompositeCacheAttributes(props, "", DEFAULT_REGION);
        this.compositeCacheManager.setDefaultCacheAttributes(icca);
        log.info((Object)("setting defaultCompositeCacheAttributes to " + icca));
    }

    protected void setDefaultElementAttributes(Properties props) {
        IElementAttributes iea = this.parseElementAttributes(props, "", DEFAULT_REGION);
        this.compositeCacheManager.setDefaultElementAttributes(iea);
        log.info((Object)("setting defaultElementAttributes to " + iea));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <K, V> void parseSystemRegions(Properties props) {
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            CompositeCache<K, V> cache;
            String key = (String)en.nextElement();
            if (!key.startsWith(SYSTEM_REGION_PREFIX) || key.indexOf("attributes") != -1) continue;
            String regionName = key.substring(SYSTEM_REGION_PREFIX.length());
            String value = OptionConverter.findAndSubst(key, props);
            String string = regionName;
            synchronized (string) {
                cache = this.parseRegion(props, regionName, value, null, SYSTEM_REGION_PREFIX);
            }
            this.compositeCacheManager.addCache(regionName, cache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <K, V> void parseRegions(Properties props) {
        ArrayList<String> regionNames = new ArrayList<String>();
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            CompositeCache<K, V> cache;
            String key = (String)en.nextElement();
            if (!key.startsWith(REGION_PREFIX) || key.indexOf("attributes") != -1) continue;
            String regionName = key.substring(REGION_PREFIX.length());
            regionNames.add(regionName);
            String auxiliaryList = OptionConverter.findAndSubst(key, props);
            String string = regionName;
            synchronized (string) {
                cache = this.parseRegion(props, regionName, auxiliaryList);
            }
            this.compositeCacheManager.addCache(regionName, cache);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Parsed regions " + regionNames));
        }
    }

    protected <K, V> CompositeCache<K, V> parseRegion(Properties props, String regName, String value) {
        return this.parseRegion(props, regName, value, null, REGION_PREFIX);
    }

    protected <K, V> CompositeCache<K, V> parseRegion(Properties props, String regName, String value, ICompositeCacheAttributes cca) {
        return this.parseRegion(props, regName, value, cca, REGION_PREFIX);
    }

    protected <K, V> CompositeCache<K, V> parseRegion(Properties props, String regName, String value, ICompositeCacheAttributes cca, String regionPrefix) {
        IElementAttributes ea = this.parseElementAttributes(props, regName, regionPrefix);
        CompositeCache cache = cca == null ? new CompositeCache(this.parseCompositeCacheAttributes(props, regName, regionPrefix), ea) : new CompositeCache(cca, ea);
        cache.setScheduledExecutorService(this.compositeCacheManager.getScheduledExecutorService());
        cache.setElementEventQueue(this.compositeCacheManager.getElementEventQueue());
        if (cache.getMemoryCache() instanceof IRequireScheduler) {
            ((IRequireScheduler)((Object)cache.getMemoryCache())).setScheduledExecutorService(this.compositeCacheManager.getScheduledExecutorService());
        }
        if (value != null) {
            ArrayList<AuxiliaryCache<K, V>> auxList = new ArrayList<AuxiliaryCache<K, V>>();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parsing region name '" + regName + "', value '" + value + "'"));
            }
            StringTokenizer st = new StringTokenizer(value, ",");
            if (!(value.startsWith(",") || value.equals("") || st.hasMoreTokens())) {
                return null;
            }
            while (st.hasMoreTokens()) {
                String auxName = st.nextToken().trim();
                if (auxName == null || auxName.equals(",")) continue;
                log.debug((Object)("Parsing auxiliary named \"" + auxName + "\"."));
                AuxiliaryCache<K, V> auxCache = this.parseAuxiliary(props, auxName, regName);
                if (auxCache == null) continue;
                if (auxCache instanceof IRequireScheduler) {
                    ((IRequireScheduler)((Object)auxCache)).setScheduledExecutorService(this.compositeCacheManager.getScheduledExecutorService());
                }
                auxList.add(auxCache);
            }
            AuxiliaryCache[] auxArray = auxList.toArray(new AuxiliaryCache[0]);
            cache.setAuxCaches(auxArray);
        }
        return cache;
    }

    protected ICompositeCacheAttributes parseCompositeCacheAttributes(Properties props, String regName) {
        return this.parseCompositeCacheAttributes(props, regName, REGION_PREFIX);
    }

    protected ICompositeCacheAttributes parseCompositeCacheAttributes(Properties props, String regName, String regionPrefix) {
        String attrName = regionPrefix + regName + CACHE_ATTRIBUTE_PREFIX;
        ICompositeCacheAttributes ccAttr = OptionConverter.instantiateByKey(props, attrName, null);
        if (ccAttr == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("No special CompositeCacheAttributes class defined for key [" + attrName + "], using default class."));
            }
            ICompositeCacheAttributes ccAttr2 = this.compositeCacheManager.getDefaultCacheAttributes();
            ccAttr = ccAttr2.copy();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parsing options for '" + attrName + "'"));
        }
        PropertySetter.setProperties(ccAttr, props, attrName + ".");
        ccAttr.setCacheName(regName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("End of parsing for \"" + attrName + "\"."));
        }
        ccAttr.setCacheName(regName);
        return ccAttr;
    }

    protected IElementAttributes parseElementAttributes(Properties props, String regName, String regionPrefix) {
        String attrName = regionPrefix + regName + ELEMENT_ATTRIBUTE_PREFIX;
        IElementAttributes eAttr = OptionConverter.instantiateByKey(props, attrName, null);
        if (eAttr == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("No special ElementAttribute class defined for key [" + attrName + "], using default class."));
            }
            IElementAttributes eAttr2 = this.compositeCacheManager.getDefaultElementAttributes();
            eAttr = eAttr2.copy();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parsing options for '" + attrName + "'"));
        }
        PropertySetter.setProperties(eAttr, props, attrName + ".");
        if (log.isDebugEnabled()) {
            log.debug((Object)("End of parsing for \"" + attrName + "\"."));
        }
        return eAttr;
    }

    protected <K, V> AuxiliaryCache<K, V> parseAuxiliary(Properties props, String auxName, String regName) {
        AuxiliaryCacheFactory auxFac;
        if (log.isDebugEnabled()) {
            log.debug((Object)("parseAuxiliary " + auxName));
        }
        if ((auxFac = this.compositeCacheManager.registryFacGet(auxName)) == null) {
            String prefix = AUXILIARY_PREFIX + auxName;
            auxFac = OptionConverter.instantiateByKey(props, prefix, null);
            if (auxFac == null) {
                log.error((Object)("Could not instantiate auxFactory named \"" + auxName + "\"."));
                return null;
            }
            auxFac.setName(auxName);
            this.compositeCacheManager.registryFacPut(auxFac);
        }
        AuxiliaryCacheAttributes auxAttr = this.compositeCacheManager.registryAttrGet(auxName);
        String attrName = AUXILIARY_PREFIX + auxName + ATTRIBUTE_PREFIX;
        if (auxAttr == null) {
            String prefix = AUXILIARY_PREFIX + auxName + ATTRIBUTE_PREFIX;
            auxAttr = OptionConverter.instantiateByKey(props, prefix, null);
            if (auxAttr == null) {
                log.error((Object)("Could not instantiate auxAttr named '" + attrName + "'"));
                return null;
            }
            auxAttr.setName(auxName);
            this.compositeCacheManager.registryAttrPut(auxAttr);
        }
        auxAttr = auxAttr.copy();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parsing options for '" + attrName + "'"));
        }
        PropertySetter.setProperties(auxAttr, props, attrName + ".");
        auxAttr.setCacheName(regName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("End of parsing for '" + attrName + "'"));
        }
        auxAttr.setCacheName(regName);
        String auxPrefix = AUXILIARY_PREFIX + auxName;
        ICacheEventLogger cacheEventLogger = AuxiliaryCacheConfigurator.parseCacheEventLogger(props, auxPrefix);
        IElementSerializer elementSerializer = AuxiliaryCacheConfigurator.parseElementSerializer(props, auxPrefix);
        AuxiliaryCache auxCache = auxFac.createCache(auxAttr, this.compositeCacheManager, cacheEventLogger, elementSerializer);
        return auxCache;
    }

    public static <K> IKeyMatcher<K> parseKeyMatcher(Properties props, String auxPrefix) {
        String keyMatcherClassName = auxPrefix + KEY_MATCHER_PREFIX;
        KeyMatcherPatternImpl keyMatcher = OptionConverter.instantiateByKey(props, keyMatcherClassName, null);
        if (keyMatcher != null) {
            String attributePrefix = auxPrefix + KEY_MATCHER_PREFIX + ATTRIBUTE_PREFIX;
            PropertySetter.setProperties(keyMatcher, props, attributePrefix + ".");
            if (log.isInfoEnabled()) {
                log.info((Object)("Using custom key matcher [" + keyMatcher + "] for auxiliary [" + auxPrefix + "]"));
            }
        } else {
            keyMatcher = new KeyMatcherPatternImpl();
            if (log.isInfoEnabled()) {
                log.info((Object)("Using standard key matcher [" + keyMatcher + "] for auxiliary [" + auxPrefix + "]"));
            }
        }
        return keyMatcher;
    }
}

