/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine.control.event;

import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.jcs.engine.control.event.behavior.IElementEvent;
import org.apache.commons.jcs.engine.control.event.behavior.IElementEventHandler;
import org.apache.commons.jcs.engine.control.event.behavior.IElementEventQueue;
import org.apache.commons.jcs.utils.threadpool.DaemonThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ElementEventQueue
implements IElementEventQueue {
    private static final String THREAD_PREFIX = "JCS-ElementEventQueue-";
    private static final Log log = LogFactory.getLog(ElementEventQueue.class);
    private boolean destroyed = false;
    private LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue();
    private ThreadPoolExecutor queueProcessor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, this.queue, new DaemonThreadFactory("JCS-ElementEventQueue-"));

    public ElementEventQueue() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Constructed: " + this));
        }
    }

    @Override
    public void dispose() {
        if (!this.destroyed) {
            this.destroyed = true;
            this.queueProcessor.shutdownNow();
            this.queueProcessor = null;
            if (log.isInfoEnabled()) {
                log.info((Object)("Element event queue destroyed: " + this));
            }
        }
    }

    @Override
    public void addElementEvent(IElementEventHandler hand, IElementEvent event) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding Event Handler to QUEUE, !destroyed = " + !this.destroyed));
        }
        if (this.destroyed) {
            log.warn((Object)("Event submitted to disposed element event queue " + event));
        } else {
            ElementEventRunner runner = new ElementEventRunner(hand, event);
            if (log.isDebugEnabled()) {
                log.debug((Object)("runner = " + runner));
            }
            this.queueProcessor.execute(runner);
        }
    }

    private class ElementEventRunner
    extends AbstractElementEventRunner {
        private final IElementEventHandler hand;
        private final IElementEvent event;

        ElementEventRunner(IElementEventHandler hand, IElementEvent event) throws IOException {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Constructing " + this));
            }
            this.hand = hand;
            this.event = event;
        }

        @Override
        protected void doRun() throws IOException {
            this.hand.handleElementEvent(this.event);
        }
    }

    protected abstract class AbstractElementEventRunner
    implements Runnable {
        protected AbstractElementEventRunner() {
        }

        @Override
        public void run() {
            try {
                this.doRun();
            }
            catch (IOException e) {
                log.warn((Object)("Giving up element event handling " + ElementEventQueue.this), (Throwable)e);
            }
        }

        protected abstract void doRun() throws IOException;
    }
}

