/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine.memory;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.jcs.engine.CacheStatus;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs.engine.behavior.IElementAttributes;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.jcs.engine.memory.behavior.IMemoryCache;
import org.apache.commons.jcs.engine.memory.util.MemoryElementDescriptor;
import org.apache.commons.jcs.engine.stats.Stats;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractMemoryCache<K, V>
implements IMemoryCache<K, V> {
    private static final Log log = LogFactory.getLog(AbstractMemoryCache.class);
    protected String cacheName;
    public Map<K, MemoryElementDescriptor<K, V>> map;
    public IElementAttributes elementAttributes;
    public ICompositeCacheAttributes cacheAttributes;
    public CompositeCache<K, V> cache;
    private CacheStatus status;
    protected int chunkSize;
    protected final Lock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(CompositeCache<K, V> hub) {
        this.lock.lock();
        try {
            this.cacheName = hub.getCacheName();
            this.cacheAttributes = hub.getCacheAttributes();
            this.cache = hub;
            this.map = this.createMap();
            this.chunkSize = this.cacheAttributes.getSpoolChunkSize();
            this.status = CacheStatus.ALIVE;
        }
        finally {
            this.lock.unlock();
        }
    }

    public abstract Map<K, MemoryElementDescriptor<K, V>> createMap();

    @Override
    public abstract boolean remove(K var1) throws IOException;

    @Override
    public abstract ICacheElement<K, V> get(K var1) throws IOException;

    @Override
    public Map<K, ICacheElement<K, V>> getMultiple(Set<K> keys) throws IOException {
        HashMap<K, ICacheElement<K, V>> elements = new HashMap<K, ICacheElement<K, V>>();
        if (keys != null && !keys.isEmpty()) {
            for (K key : keys) {
                ICacheElement<K, V> element = this.get(key);
                if (element == null) continue;
                elements.put(key, element);
            }
        }
        return elements;
    }

    @Override
    public ICacheElement<K, V> getQuiet(K key) throws IOException {
        ICacheElement ce = null;
        MemoryElementDescriptor<K, V> me = this.map.get(key);
        if (me != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.cacheName + ": MemoryCache quiet hit for " + key));
            }
            ce = me.ce;
        } else if (log.isDebugEnabled()) {
            log.debug((Object)(this.cacheName + ": MemoryCache quiet miss for " + key));
        }
        return ce;
    }

    @Override
    public abstract void update(ICacheElement<K, V> var1) throws IOException;

    @Override
    public abstract Set<K> getKeySet();

    @Override
    public void removeAll() throws IOException {
        this.map.clear();
    }

    @Override
    public void dispose() throws IOException {
        log.info((Object)"Memory Cache dispose called.");
    }

    @Override
    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Abstract Memory Cache");
        return stats;
    }

    @Override
    public int getSize() {
        return this.map.size();
    }

    public CacheStatus getStatus() {
        return this.status;
    }

    public String getCacheName() {
        String attributeCacheName = this.cacheAttributes.getCacheName();
        if (attributeCacheName != null) {
            return attributeCacheName;
        }
        return this.cacheName;
    }

    @Override
    public void waterfal(ICacheElement<K, V> ce) throws IOException {
        this.cache.spoolToDisk(ce);
    }

    public void dumpMap() {
        log.debug((Object)"dumpingMap");
        for (Map.Entry<K, MemoryElementDescriptor<K, V>> e : this.map.entrySet()) {
            MemoryElementDescriptor<K, V> me = e.getValue();
            log.debug((Object)("dumpMap> key=" + e.getKey() + ", val=" + me.ce.getVal()));
        }
    }

    @Override
    public ICompositeCacheAttributes getCacheAttributes() {
        return this.cacheAttributes;
    }

    @Override
    public void setCacheAttributes(ICompositeCacheAttributes cattr) {
        this.cacheAttributes = cattr;
    }

    @Override
    public CompositeCache<K, V> getCompositeCache() {
        return this.cache;
    }
}

