/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine.memory.lru;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.jcs.engine.control.group.GroupAttrName;
import org.apache.commons.jcs.engine.memory.AbstractMemoryCache;
import org.apache.commons.jcs.engine.memory.lru.LRUMemoryCache;
import org.apache.commons.jcs.engine.memory.util.MemoryElementDescriptor;
import org.apache.commons.jcs.engine.stats.StatElement;
import org.apache.commons.jcs.engine.stats.Stats;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LHMLRUMemoryCache<K extends Serializable, V extends Serializable>
extends AbstractMemoryCache<K, V> {
    private static final Log log = LogFactory.getLog(LRUMemoryCache.class);
    private int hitCnt = 0;
    private int missCnt = 0;
    private int putCnt = 0;

    @Override
    public synchronized void initialize(CompositeCache<K, V> hub) {
        super.initialize(hub);
        log.info((Object)("initialized LHMLRUMemoryCache for " + this.cacheName));
    }

    @Override
    public Map<K, MemoryElementDescriptor<K, V>> createMap() {
        return Collections.synchronizedMap(new LHMSpooler());
    }

    @Override
    public void update(ICacheElement<K, V> ce) throws IOException {
        ++this.putCnt;
        this.map.put(ce.getKey(), new MemoryElementDescriptor<K, V>(ce));
    }

    @Override
    public ICacheElement<K, V> getQuiet(K key) throws IOException {
        return ((MemoryElementDescriptor)this.map.get(key)).ce;
    }

    @Override
    public synchronized ICacheElement<K, V> get(K key) throws IOException {
        MemoryElementDescriptor me = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getting item from cache " + this.cacheName + " for key " + key));
        }
        if ((me = (MemoryElementDescriptor)this.map.get(key)) != null) {
            ++this.hitCnt;
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.cacheName + ": LRUMemoryCache hit for " + key));
            }
            return me.ce;
        }
        ++this.missCnt;
        log.debug((Object)(this.cacheName + ": LRUMemoryCache miss for " + key));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean remove(K key) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removing item for key: " + key));
        }
        boolean removed = false;
        if (key instanceof String && ((String)key).endsWith(":")) {
            Map map = this.map;
            synchronized (map) {
                Iterator itr = this.map.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    Serializable k = (Serializable)entry.getKey();
                    if (!(k instanceof String) || !((String)((Object)k)).startsWith(key.toString())) continue;
                    itr.remove();
                    removed = true;
                }
            }
        } else if (key instanceof GroupAttrName && ((GroupAttrName)key).attrName == null) {
            Map map = this.map;
            synchronized (map) {
                Iterator itr = this.map.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    Serializable k = (Serializable)entry.getKey();
                    if (!(k instanceof GroupAttrName) || !((GroupAttrName)k).groupId.equals(((GroupAttrName)key).groupId)) continue;
                    itr.remove();
                    removed = true;
                }
            }
        } else {
            MemoryElementDescriptor me = (MemoryElementDescriptor)this.map.remove(key);
            if (me != null) {
                removed = true;
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> getKeySet() {
        LHMLRUMemoryCache lHMLRUMemoryCache = this;
        synchronized (lHMLRUMemoryCache) {
            return new LinkedHashSet(this.map.keySet());
        }
    }

    @Override
    public synchronized IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("LHMLRU Memory Cache");
        ArrayList elems = new ArrayList();
        elems.add(new StatElement<Integer>("Map Size", this.map.size()));
        elems.add(new StatElement<Integer>("Put Count", this.putCnt));
        elems.add(new StatElement<Integer>("Hit Count", this.hitCnt));
        elems.add(new StatElement<Integer>("Miss Count", this.missCnt));
        stats.setStatElements(elems);
        return stats;
    }

    public void dumpCacheEntries() {
        this.dumpMap();
    }

    @Override
    public int freeElements(int numberToFree) throws IOException {
        return 0;
    }

    public class LHMSpooler
    extends LinkedHashMap<K, MemoryElementDescriptor<K, V>> {
        private static final long serialVersionUID = -1255907868906762484L;

        public LHMSpooler() {
            super((int)((double)LHMLRUMemoryCache.this.cache.getCacheAttributes().getMaxObjects() * 0.5), 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, MemoryElementDescriptor<K, V>> eldest) {
            ICacheElement element = eldest.getValue().ce;
            if (this.size() <= LHMLRUMemoryCache.this.cache.getCacheAttributes().getMaxObjects()) {
                return false;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("LHMLRU max size: " + LHMLRUMemoryCache.this.cache.getCacheAttributes().getMaxObjects() + ".  Spooling element, key: " + element.getKey()));
            }
            this.spoolToDisk(element);
            if (log.isDebugEnabled()) {
                log.debug((Object)("LHMLRU size: " + LHMLRUMemoryCache.this.map.size()));
            }
            return true;
        }

        private void spoolToDisk(ICacheElement<K, V> element) {
            LHMLRUMemoryCache.this.cache.spoolToDisk(element);
            if (log.isDebugEnabled()) {
                log.debug((Object)(LHMLRUMemoryCache.this.cache.getCacheName() + "Spooled element to disk: " + element.getKey()));
            }
        }
    }
}

