/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.access;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jcs.JCS;
import org.apache.commons.jcs.access.CacheAccess;
import org.apache.commons.jcs.access.GroupCacheAccess;
import org.apache.commons.jcs.access.exception.CacheException;
import org.apache.commons.jcs.utils.access.JCSWorkerHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JCSWorker<K extends Serializable, V extends Serializable> {
    private static final Log logger = LogFactory.getLog(JCSWorker.class);
    private CacheAccess<K, V> cache;
    private GroupCacheAccess<K, V> groupCache;
    private static volatile Map<String, JCSWorkerHelper> map = new HashMap<String, JCSWorkerHelper>();
    private final String region;

    public JCSWorker(String aRegion) {
        this.region = aRegion;
        try {
            this.cache = JCS.getInstance(aRegion);
            this.groupCache = JCS.getGroupCacheInstance(aRegion);
        }
        catch (CacheException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public String getRegion() {
        return this.region;
    }

    public V getResult(K aKey, JCSWorkerHelper aWorker) throws Exception {
        return this.run(aKey, null, aWorker);
    }

    public V getResult(K aKey, String aGroup, JCSWorkerHelper aWorker) throws Exception {
        return this.run(aKey, aGroup, aWorker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V run(K aKey, String aGroup, JCSWorkerHelper aHelper) throws Exception {
        Serializable result = null;
        JCSWorkerHelper helper = null;
        Object object = map;
        synchronized (object) {
            helper = map.get(this.getRegion() + aKey);
            if (helper == null) {
                map.put(this.getRegion() + aKey, aHelper);
            }
        }
        if (helper != null) {
            object = helper;
            synchronized (object) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found a worker already doing this work (" + this.getRegion() + ":" + aKey + ")."));
                }
                if (!helper.isFinished()) {
                    helper.wait();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Another thread finished our work for us. Using those results instead. (" + this.getRegion() + ":" + aKey + ")."));
                }
            }
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.getRegion() + " is doing the work."));
            }
            if ((result = aGroup != null ? (Serializable)this.groupCache.getFromGroup(aKey, aGroup) : (Serializable)this.cache.get(aKey)) == null) {
                Serializable doWork;
                result = doWork = (Serializable)aHelper.doWork();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Work Done, caching: key:" + aKey + ", group:" + aGroup + ", result:" + result + "."));
                }
                if (aGroup != null) {
                    this.groupCache.putInGroup(aKey, aGroup, result);
                } else {
                    this.cache.put(aKey, result);
                }
            }
            object = result;
            return (V)object;
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.getRegion() + ":" + aKey + " entered finally."));
            }
            Map<String, JCSWorkerHelper> map = JCSWorker.map;
            synchronized (map) {
                if (helper == null) {
                    JCSWorker.map.remove(this.getRegion() + aKey);
                }
                JCSWorkerHelper jCSWorkerHelper = aHelper;
                synchronized (jCSWorkerHelper) {
                    aHelper.setFinished(true);
                    aHelper.notifyAll();
                }
            }
        }
    }
}

