/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.discovery;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.jcs.engine.CacheInfo;
import org.apache.commons.jcs.engine.behavior.IShutdownObserver;
import org.apache.commons.jcs.io.ObjectInputStreamClassLoaderAware;
import org.apache.commons.jcs.utils.discovery.DiscoveredService;
import org.apache.commons.jcs.utils.discovery.UDPDiscoveryMessage;
import org.apache.commons.jcs.utils.discovery.UDPDiscoveryService;
import org.apache.commons.jcs.utils.threadpool.DaemonThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPDiscoveryReceiver
implements Runnable,
IShutdownObserver {
    private static final Log log = LogFactory.getLog(UDPDiscoveryReceiver.class);
    private final byte[] mBuffer = new byte[65536];
    private MulticastSocket mSocket;
    private static final int maxPoolSize = 2;
    private ThreadPoolExecutor pooledExecutor = null;
    private int cnt = 0;
    private UDPDiscoveryService service = null;
    private String multicastAddressString = "";
    private int multicastPort = 0;
    private boolean shutdown = false;

    public UDPDiscoveryReceiver(UDPDiscoveryService service, String multicastAddressString, int multicastPort) throws IOException {
        this.service = service;
        this.multicastAddressString = multicastAddressString;
        this.multicastPort = multicastPort;
        this.pooledExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(2, new DaemonThreadFactory("JCS-UDPDiscoveryReceiver-", 1));
        this.pooledExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardOldestPolicy());
        if (log.isInfoEnabled()) {
            log.info((Object)("Constructing listener, [" + this.multicastAddressString + ":" + this.multicastPort + "]"));
        }
        this.createSocket(this.multicastAddressString, this.multicastPort);
    }

    private void createSocket(String multicastAddressString, int multicastPort) throws IOException {
        try {
            this.mSocket = new MulticastSocket(multicastPort);
            if (log.isInfoEnabled()) {
                log.info((Object)("Joining Group: [" + InetAddress.getByName(multicastAddressString) + "]"));
            }
            this.mSocket.joinGroup(InetAddress.getByName(multicastAddressString));
        }
        catch (IOException e) {
            log.error((Object)("Could not bind to multicast address [" + InetAddress.getByName(multicastAddressString) + ":" + multicastPort + "]"), (Throwable)e);
            throw e;
        }
    }

    public Object waitForMessage() throws IOException {
        DatagramPacket packet = new DatagramPacket(this.mBuffer, this.mBuffer.length);
        Object obj = null;
        try {
            ByteArrayInputStream byteStream;
            ObjectInputStreamClassLoaderAware objectStream;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Waiting for message.");
            }
            this.mSocket.receive(packet);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Received packet from address [" + packet.getSocketAddress() + "]"));
            }
            if ((obj = (objectStream = new ObjectInputStreamClassLoaderAware(byteStream = new ByteArrayInputStream(this.mBuffer, 0, packet.getLength()), null)).readObject()) != null && obj instanceof UDPDiscoveryMessage) {
                UDPDiscoveryMessage msg = (UDPDiscoveryMessage)obj;
                msg.setHost(packet.getAddress().getHostAddress());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Read object from address [" + packet.getSocketAddress() + "], object=[" + obj + "]"));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error receiving multicast packet", (Throwable)e);
        }
        return obj;
    }

    @Override
    public void run() {
        block6: while (true) {
            try {
                while (!this.shutdown) {
                    Object obj = this.waitForMessage();
                    ++this.cnt;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(this.getCnt() + " messages received."));
                    }
                    UDPDiscoveryMessage message = null;
                    try {
                        message = (UDPDiscoveryMessage)obj;
                        if (message != null) {
                            MessageHandler handler = new MessageHandler(message);
                            this.pooledExecutor.execute(handler);
                            if (!log.isDebugEnabled()) continue block6;
                            log.debug((Object)"Passed handler to executor.");
                            continue block6;
                        }
                        log.warn((Object)"message is null");
                        continue block6;
                    }
                    catch (ClassCastException cce) {
                        log.warn((Object)("Received unknown message type " + cce.getMessage()));
                    }
                }
                break;
            }
            catch (Exception e) {
                log.error((Object)"Unexpected exception in UDP receiver.", (Throwable)e);
                try {
                    Thread.sleep(100L);
                    break;
                }
                catch (Exception e2) {
                    log.error((Object)"Problem sleeping", (Throwable)e2);
                    break;
                }
            }
        }
    }

    public void setCnt(int cnt) {
        this.cnt = cnt;
    }

    public int getCnt() {
        return this.cnt;
    }

    @Override
    public void shutdown() {
        try {
            this.shutdown = true;
            this.mSocket.leaveGroup(InetAddress.getByName(this.multicastAddressString));
            this.mSocket.close();
            this.pooledExecutor.shutdownNow();
        }
        catch (IOException e) {
            log.error((Object)"Problem closing socket");
        }
    }

    public class MessageHandler
    implements Runnable {
        private UDPDiscoveryMessage message = null;

        public MessageHandler(UDPDiscoveryMessage message) {
            this.message = message;
        }

        @Override
        public void run() {
            if (this.message.getRequesterId() == CacheInfo.listenerId) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Ignoring message sent from self");
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Process message sent from another");
                    log.debug((Object)("Message = " + this.message));
                }
                if (this.message.getHost() == null || this.message.getCacheNames() == null || this.message.getCacheNames().isEmpty()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Ignoring invalid message: " + this.message));
                    }
                } else {
                    this.processMessage();
                }
            }
        }

        private void processMessage() {
            DiscoveredService discoveredService = new DiscoveredService();
            discoveredService.setServiceAddress(this.message.getHost());
            discoveredService.setCacheNames(this.message.getCacheNames());
            discoveredService.setServicePort(this.message.getPort());
            discoveredService.setLastHearFromTime(System.currentTimeMillis());
            if (this.message.getMessageType() == UDPDiscoveryMessage.BroadcastType.REQUEST) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Message is a Request Broadcast, will have the service handle it.");
                }
                UDPDiscoveryReceiver.this.service.serviceRequestBroadcast();
                return;
            }
            if (this.message.getMessageType() == UDPDiscoveryMessage.BroadcastType.REMOVE) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removing service from set " + discoveredService));
                }
                UDPDiscoveryReceiver.this.service.removeDiscoveredService(discoveredService);
            } else {
                UDPDiscoveryReceiver.this.service.addOrUpdateService(discoveredService);
            }
        }
    }
}

