/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.struct;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.jcs.engine.control.group.GroupAttrName;
import org.apache.commons.jcs.engine.stats.StatElement;
import org.apache.commons.jcs.engine.stats.Stats;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.jcs.utils.struct.DoubleLinkedList;
import org.apache.commons.jcs.utils.struct.LRUElementDescriptor;
import org.apache.commons.jcs.utils.struct.LRUMapEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LRUMap<K, V>
implements Map<K, V> {
    private static final Log log = LogFactory.getLog(LRUMap.class);
    private final DoubleLinkedList<LRUElementDescriptor<K, V>> list;
    private Map<K, LRUElementDescriptor<K, V>> map;
    int hitCnt = 0;
    int missCnt = 0;
    int putCnt = 0;
    int maxObjects = -1;
    private int chunkSize = 1;
    private final Lock lock = new ReentrantLock();

    public LRUMap() {
        this.list = new DoubleLinkedList();
        this.map = new ConcurrentHashMap<K, LRUElementDescriptor<K, V>>();
    }

    public LRUMap(int maxObjects) {
        this();
        this.maxObjects = maxObjects;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.map.clear();
            this.list.removeAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.map.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Collection<V> values() {
        ArrayList valueList = new ArrayList(this.map.size());
        for (LRUElementDescriptor<K, V> value : this.map.values()) {
            valueList.add(value.getPayload());
        }
        return valueList;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> source) {
        if (source != null) {
            for (Map.Entry<K, V> entry : source.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public V get(Object key) {
        LRUElementDescriptor<K, V> me;
        V retVal = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getting item  for key " + key));
        }
        if ((me = this.map.get(key)) != null) {
            ++this.hitCnt;
            if (log.isDebugEnabled()) {
                log.debug((Object)("LRUMap hit for " + key));
            }
            retVal = (V)me.getPayload();
            this.list.makeFirst(me);
        } else {
            ++this.missCnt;
            log.debug((Object)("LRUMap miss for " + key));
        }
        return retVal;
    }

    public V getQuiet(Object key) {
        V ce = null;
        LRUElementDescriptor<K, V> me = this.map.get(key);
        if (me != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("LRUMap quiet hit for " + key));
            }
            ce = (V)me.getPayload();
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("LRUMap quiet miss for " + key));
        }
        return ce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removing item for key: " + key));
        }
        this.lock.lock();
        try {
            LRUElementDescriptor<K, V> me = this.map.remove(key);
            if (me != null) {
                this.list.remove(me);
                Object t = me.getPayload();
                return (V)t;
            }
        }
        finally {
            this.lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        ++this.putCnt;
        LRUElementDescriptor<K, V> old = null;
        this.lock.lock();
        try {
            this.addFirst(key, value);
            LRUElementDescriptor<K, V> first = this.list.getFirst();
            old = this.map.put(first.getKey(), first);
            if (old != null && first.getKey().equals(old.getKey())) {
                this.list.remove(old);
            }
        }
        finally {
            this.lock.unlock();
        }
        int size = this.map.size();
        if (this.maxObjects >= 0 && size > this.maxObjects) {
            boolean debugEnabled = log.isDebugEnabled();
            if (debugEnabled) {
                log.debug((Object)"In memory limit reached, removing least recently used.");
            }
            int chunkSizeCorrected = Math.min(size, this.getChunkSize());
            if (debugEnabled) {
                log.debug((Object)("About to remove the least recently used. map size: " + size + ", max objects: " + this.maxObjects + ", items to spool: " + chunkSizeCorrected));
            }
            for (int i = 0; i < chunkSizeCorrected; ++i) {
                this.lock.lock();
                try {
                    LRUElementDescriptor<K, V> last = this.list.getLast();
                    if (last != null) {
                        this.processRemovedLRU(last.getKey(), last.getPayload());
                        if (this.map.remove(last.getKey()) == null) {
                            log.warn((Object)("update: remove failed for key: " + last.getKey()));
                            this.verifyCache();
                        }
                        this.list.removeLast();
                        continue;
                    }
                    this.verifyCache();
                    throw new Error("update: last is null!");
                }
                finally {
                    this.lock.unlock();
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("update: After spool map size: " + this.map.size()));
            }
            if (this.map.size() != this.dumpCacheSize()) {
                log.error((Object)("update: After spool, size mismatch: map.size() = " + this.map.size() + ", linked list size = " + this.dumpCacheSize()));
            }
        }
        if (old != null) {
            return (V)old.getPayload();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFirst(K key, V val) {
        this.lock.lock();
        try {
            LRUElementDescriptor<K, V> me = new LRUElementDescriptor<K, V>(key, val);
            this.list.addFirst(me);
        }
        finally {
            this.lock.unlock();
        }
    }

    private int dumpCacheSize() {
        return this.list.size();
    }

    public void dumpCacheEntries() {
        log.debug((Object)"dumpingCacheEntries");
        LRUElementDescriptor me = this.list.getFirst();
        while (me != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("dumpCacheEntries> key=" + me.getKey() + ", val=" + me.getPayload()));
            }
            me = (LRUElementDescriptor)me.next;
        }
    }

    public void dumpMap() {
        log.debug((Object)"dumpingMap");
        for (Map.Entry<K, LRUElementDescriptor<K, V>> e : this.map.entrySet()) {
            LRUElementDescriptor<K, V> me = e.getValue();
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("dumpMap> key=" + e.getKey() + ", val=" + me.getPayload()));
        }
    }

    protected void verifyCache() {
        if (!log.isDebugEnabled()) {
            return;
        }
        boolean found = false;
        log.debug((Object)("verifycache: mapContains " + this.map.size() + " elements, linked list contains " + this.dumpCacheSize() + " elements"));
        log.debug((Object)"verifycache: checking linked list by key ");
        LRUElementDescriptor li = this.list.getFirst();
        while (li != null) {
            K key = li.getKey();
            if (!this.map.containsKey(key)) {
                log.error((Object)("verifycache: map does not contain key : " + li.getKey()));
                log.error((Object)("li.hashcode=" + li.getKey().hashCode()));
                log.error((Object)("key class=" + key.getClass()));
                log.error((Object)("key hashcode=" + key.hashCode()));
                log.error((Object)("key toString=" + key.toString()));
                if (key instanceof GroupAttrName) {
                    GroupAttrName name = (GroupAttrName)key;
                    log.error((Object)("GroupID hashcode=" + name.groupId.hashCode()));
                    log.error((Object)("GroupID.class=" + name.groupId.getClass()));
                    log.error((Object)("AttrName hashcode=" + name.attrName.hashCode()));
                    log.error((Object)("AttrName.class=" + name.attrName.getClass()));
                }
                this.dumpMap();
            } else if (this.map.get(li.getKey()) == null) {
                log.error((Object)("verifycache: linked list retrieval returned null for key: " + li.getKey()));
            }
            li = (LRUElementDescriptor)li.next;
        }
        log.debug((Object)"verifycache: checking linked list by value ");
        LRUElementDescriptor li3 = this.list.getFirst();
        while (li3 != null) {
            if (!this.map.containsValue(li3)) {
                log.error((Object)("verifycache: map does not contain value : " + li3));
                this.dumpMap();
            }
            li3 = (LRUElementDescriptor)li3.next;
        }
        log.debug((Object)"verifycache: checking via keysets!");
        Iterator<K> itr2 = this.map.keySet().iterator();
        while (itr2.hasNext()) {
            found = false;
            Serializable val = null;
            try {
                val = (Serializable)itr2.next();
            }
            catch (NoSuchElementException nse) {
                log.error((Object)"verifycache: no such element exception");
                continue;
            }
            LRUElementDescriptor li2 = this.list.getFirst();
            while (li2 != null) {
                if (val.equals(li2.getKey())) {
                    found = true;
                    break;
                }
                li2 = (LRUElementDescriptor)li2.next;
            }
            if (found) continue;
            log.error((Object)("verifycache: key not found in list : " + val));
            this.dumpCacheEntries();
            if (this.map.containsKey(val)) {
                log.error((Object)"verifycache: map contains key");
                continue;
            }
            log.error((Object)"verifycache: map does NOT contain key, what the HECK!");
        }
    }

    protected void verifyCache(Object key) {
        if (!log.isDebugEnabled()) {
            return;
        }
        boolean found = false;
        LRUElementDescriptor li = this.list.getFirst();
        while (li != null) {
            if (li.getKey() == key) {
                found = true;
                log.debug((Object)("verifycache(key) key match: " + key));
                break;
            }
            li = (LRUElementDescriptor)li.next;
        }
        if (!found) {
            log.error((Object)("verifycache(key), couldn't find key! : " + key));
        }
    }

    protected void processRemovedLRU(K key, V value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing key: [" + key + "] from LRUMap store, value = [" + value + "]"));
            log.debug((Object)("LRUMap store size: '" + this.size() + "'."));
        }
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("LRUMap");
        ArrayList elems = new ArrayList();
        elems.add(new StatElement<Integer>("List Size", this.list.size()));
        elems.add(new StatElement<Integer>("Map Size", this.map.size()));
        elems.add(new StatElement<Integer>("Put Count", this.putCnt));
        elems.add(new StatElement<Integer>("Hit Count", this.hitCnt));
        elems.add(new StatElement<Integer>("Miss Count", this.missCnt));
        stats.setStatElements(elems);
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.lock.lock();
        try {
            Set<Map.Entry<K, LRUElementDescriptor<K, V>>> entries = this.map.entrySet();
            HashSet<Map.Entry<K, V>> unWrapped = new HashSet<Map.Entry<K, V>>();
            for (Map.Entry<K, LRUElementDescriptor<K, V>> pre : entries) {
                LRUMapEntry post = new LRUMapEntry(pre.getKey(), pre.getValue().getPayload());
                unWrapped.add(post);
            }
            HashSet<Map.Entry<K, V>> hashSet = unWrapped;
            return hashSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    public int getMaxObjects() {
        return this.maxObjects;
    }
}

