/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.jcache.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import javax.cache.annotation.CacheDefaults;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CacheResolverFactory;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import org.apache.commons.jcs.jcache.cdi.CacheKeyGeneratorImpl;
import org.apache.commons.jcs.jcache.cdi.CacheResolverFactoryImpl;

@ApplicationScoped
public class CDIJCacheHelper {
    private static final Logger LOGGER = Logger.getLogger(CDIJCacheHelper.class.getName());
    private final CacheResolverFactory defaultCacheResolverFactory = new CacheResolverFactoryImpl();
    private final CacheKeyGeneratorImpl defaultCacheKeyGenerator = new CacheKeyGeneratorImpl();
    private final ConcurrentMap<Method, String> generatedNames = new ConcurrentHashMap<Method, String>();
    @Inject
    private BeanManager beanManager;

    public String defaultName(Method method, CacheDefaults defaults, String cacheName) {
        String name;
        if (!cacheName.isEmpty()) {
            return cacheName;
        }
        if (defaults != null && !(name = defaults.cacheName()).isEmpty()) {
            return name;
        }
        String computedName = (String)this.generatedNames.get(method);
        if (computedName == null) {
            StringBuilder name2 = new StringBuilder(method.getDeclaringClass().getName());
            name2.append(".");
            name2.append(method.getName());
            name2.append("(");
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (int pIdx = 0; pIdx < parameterTypes.length; ++pIdx) {
                name2.append(parameterTypes[pIdx].getName());
                if (pIdx + 1 >= parameterTypes.length) continue;
                name2.append(",");
            }
            name2.append(")");
            computedName = name2.toString();
            this.generatedNames.putIfAbsent(method, computedName);
        }
        return computedName;
    }

    public CacheDefaults findDefaults(InvocationContext ic) {
        CacheDefaults annotation = null;
        for (Class<?> clazz = ic.getTarget().getClass(); clazz != null && clazz != Object.class && (annotation = clazz.getAnnotation(CacheDefaults.class)) == null; clazz = clazz.getSuperclass()) {
        }
        return annotation;
    }

    public boolean isIncluded(Class<?> aClass, Class<?>[] in, Class<?>[] out) {
        if (in.length == 0 && out.length == 0) {
            return false;
        }
        for (Class<?> potentialIn : in) {
            if (!potentialIn.isAssignableFrom(aClass)) continue;
            for (Class<?> potentialOut : out) {
                if (!potentialOut.isAssignableFrom(aClass)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public CacheKeyGenerator cacheKeyGeneratorFor(CacheDefaults defaults, Class<? extends CacheKeyGenerator> cacheKeyGenerator) {
        Class defaultCacheKeyGenerator;
        if (!CacheKeyGenerator.class.equals(cacheKeyGenerator)) {
            return this.instance(cacheKeyGenerator);
        }
        if (defaults != null && !CacheResolverFactory.class.equals((Object)(defaultCacheKeyGenerator = defaults.cacheKeyGenerator()))) {
            return (CacheKeyGenerator)this.instance(defaultCacheKeyGenerator);
        }
        return this.defaultCacheKeyGenerator;
    }

    public CacheResolverFactory cacheResolverFactoryFor(CacheDefaults defaults, Class<? extends CacheResolverFactory> cacheResolverFactory) {
        Class defaultCacheResolverFactory;
        if (!CacheResolverFactory.class.equals(cacheResolverFactory)) {
            return this.instance(cacheResolverFactory);
        }
        if (defaults != null && !CacheResolverFactory.class.equals((Object)(defaultCacheResolverFactory = defaults.cacheResolverFactory()))) {
            return (CacheResolverFactory)this.instance(defaultCacheResolverFactory);
        }
        return this.defaultCacheResolverFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T instance(Class<T> type) {
        Set beans = this.beanManager.getBeans(type, new Annotation[0]);
        if (beans.isEmpty()) {
            return null;
        }
        Bean bean = this.beanManager.resolve(beans);
        CreationalContext context = this.beanManager.createCreationalContext((Contextual)bean);
        Class scope = bean.getScope();
        boolean dependent = Dependent.class.equals((Object)scope);
        if (!dependent && !this.beanManager.isNormalScope(scope)) {
            LOGGER.warning("Not normal scope beans (" + type.getName() + ") can leak");
        }
        try {
            Object object = this.beanManager.getReference(bean, (Type)bean.getBeanClass(), context);
            return (T)object;
        }
        finally {
            if (dependent) {
                context.release();
            }
        }
    }
}

