/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.jcache.extras;

import java.lang.reflect.Field;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.spi.CachingProvider;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class InternalCacheRule
implements TestRule {
    private final Object test;

    public InternalCacheRule(Object test) {
        this.test = test;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                CachingProvider provider = Caching.getCachingProvider();
                CacheManager manager = provider.getCacheManager();
                try {
                    Field cache = null;
                    CompleteConfiguration config = null;
                    for (Field f : InternalCacheRule.this.test.getClass().getDeclaredFields()) {
                        if (Cache.class.isAssignableFrom(f.getType())) {
                            f.setAccessible(true);
                            cache = f;
                            continue;
                        }
                        if (!Configuration.class.isAssignableFrom(f.getType())) continue;
                        f.setAccessible(true);
                        config = (CompleteConfiguration)f.get(InternalCacheRule.this.test);
                    }
                    if (cache != null) {
                        if (config == null) {
                            throw new IllegalStateException("Define a Configuration field");
                        }
                        cache.set(InternalCacheRule.this.test, manager.createCache(cache.getName(), config));
                    }
                    base.evaluate();
                }
                finally {
                    manager.close();
                    provider.close();
                }
            }
        };
    }
}

