/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk.indexed;

import junit.framework.TestCase;
import org.apache.commons.jcs.JCS;
import org.apache.commons.jcs.access.CacheAccess;

public class HugeQuantityIndDiskCacheLoadTest
extends TestCase {
    public void setUp() {
        JCS.setConfigFilename((String)"/TestDiskCacheHuge.ccf");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLargeNumberOfItems() throws Exception {
        int items = 300000;
        String region = "testCache1";
        CacheAccess jcs = JCS.getInstance((String)region);
        try {
            int i;
            System.out.println("Start: " + this.measureMemoryUse());
            for (i = 0; i <= items; ++i) {
                jcs.put((Object)(i + ":key"), (Object)(region + " data " + i));
            }
            System.out.println(jcs.getStats());
            System.out.println("--------------------------");
            System.out.println("After put: " + this.measureMemoryUse());
            Thread.sleep(5000L);
            System.out.println(jcs.getStats());
            System.out.println("--------------------------");
            System.out.println("After wait: " + this.measureMemoryUse());
            for (i = 0; i <= items; ++i) {
                String value = (String)jcs.get((Object)(i + ":key"));
                HugeQuantityIndDiskCacheLoadTest.assertEquals((String)(region + " data " + i), (String)value);
            }
            System.out.println("After get: " + this.measureMemoryUse());
        }
        finally {
            System.out.println(jcs.getStats());
            System.out.println("--------------------------");
            System.out.println("End: " + this.measureMemoryUse());
        }
    }

    protected long measureMemoryUse() throws InterruptedException {
        System.gc();
        Thread.sleep(3000L);
        System.gc();
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }
}

