/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import junit.framework.TestCase;
import org.apache.commons.jcs.JCS;
import org.apache.commons.jcs.access.CacheAccess;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.jdbc.HsqlSetupTableUtil;
import org.apache.commons.jcs.auxiliary.disk.jdbc.JDBCDiskCache;
import org.apache.commons.jcs.auxiliary.disk.jdbc.JDBCDiskCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.jdbc.JDBCDiskCacheFactory;
import org.apache.commons.jcs.auxiliary.disk.jdbc.dsfactory.DataSourceFactory;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.control.MockCompositeCacheManager;
import org.apache.commons.jcs.utils.serialization.StandardSerializer;
import org.apache.commons.jcs.utils.threadpool.DaemonThreadFactory;
import org.hsqldb.jdbcDriver;

public class JDBCDiskCacheUnitTest
extends TestCase {
    public void setUp() {
        JCS.setConfigFilename((String)"/TestJDBCDiskCache.ccf");
    }

    public void testSimpleJDBCPutGetWithHSQL() throws Exception {
        System.setProperty("hsqldb.cache_scale", "8");
        String rafroot = "target";
        Properties p = new Properties();
        String driver = p.getProperty("driver", "org.hsqldb.jdbcDriver");
        String url = p.getProperty("url", "jdbc:hsqldb:");
        String database = p.getProperty("database", rafroot + "/cache_hsql_db");
        String user = p.getProperty("user", "sa");
        String password = p.getProperty("password", "");
        new jdbcDriver();
        Class.forName(driver).newInstance();
        Connection cConn = DriverManager.getConnection(url + database, user, password);
        HsqlSetupTableUtil.setupTABLE(cConn, "JCS_STORE2");
        this.runTestForRegion("testCache1", 200);
    }

    public void runTestForRegion(String region, int items) throws Exception {
        int i;
        int i2;
        CacheAccess jcs = JCS.getInstance((String)region);
        for (i2 = 0; i2 <= items; ++i2) {
            jcs.put((Object)(i2 + ":key"), (Object)(region + " data " + i2));
        }
        Thread.sleep(1000L);
        for (i2 = 0; i2 <= items; ++i2) {
            String value = (String)jcs.get((Object)(i2 + ":key"));
            JDBCDiskCacheUnitTest.assertEquals((String)("key = [" + i2 + ":key] value = [" + value + "]"), (String)(region + " data " + i2), (String)value);
        }
        HashSet<String> keys = new HashSet<String>();
        for (int i3 = 0; i3 <= items; ++i3) {
            keys.add(i3 + ":key");
        }
        Map elements = jcs.getCacheElements(keys);
        for (i = 0; i <= items; ++i) {
            ICacheElement element = (ICacheElement)elements.get(i + ":key");
            JDBCDiskCacheUnitTest.assertNotNull((String)("element " + i + ":key is missing"), (Object)element);
            JDBCDiskCacheUnitTest.assertEquals((String)("value " + i + ":key"), (String)(region + " data " + i), (String)((String)element.getVal()));
        }
        for (i = 0; i <= items; ++i) {
            jcs.remove((Object)(i + ":key"));
        }
        for (i = 0; i <= items; ++i) {
            JDBCDiskCacheUnitTest.assertNull((String)("Removed key should be null: " + i + ":key"), (Object)jcs.get((Object)(i + ":key")));
        }
    }

    public void testInitializePoolAccess_withPoolName() throws Exception {
        String poolName = "testInitializePoolAccess_withPoolName";
        String url = "jdbc:hsqldb:";
        String userName = "sa";
        String password = "";
        int maxActive = 10;
        String driverClassName = "org.hsqldb.jdbcDriver";
        Properties props = new Properties();
        String prefix = "jcs.jdbcconnectionpool." + poolName + ".attributes";
        props.put(prefix + ".url", url);
        props.put(prefix + ".userName", userName);
        props.put(prefix + ".password", password);
        props.put(prefix + ".maxActive", String.valueOf(maxActive));
        props.put(prefix + ".driverClassName", driverClassName);
        JDBCDiskCacheAttributes cattr = new JDBCDiskCacheAttributes();
        cattr.setConnectionPoolName(poolName);
        cattr.setTableName("JCSTESTTABLE_InitializePoolAccess");
        MockCompositeCacheManager compositeCacheManager = new MockCompositeCacheManager();
        compositeCacheManager.setConfigurationProperties(props);
        JDBCDiskCacheFactory dcFactory = new JDBCDiskCacheFactory();
        dcFactory.initialize();
        dcFactory.setScheduledExecutorService(Executors.newScheduledThreadPool(2, (ThreadFactory)new DaemonThreadFactory("JCS-JDBCDiskCacheManager-", 1)));
        JDBCDiskCache diskCache = dcFactory.createCache((AuxiliaryCacheAttributes)cattr, (ICompositeCacheManager)compositeCacheManager, null, (IElementSerializer)new StandardSerializer());
        JDBCDiskCacheUnitTest.assertNotNull((String)"Should have a cache instance", (Object)diskCache);
        DataSourceFactory result = dcFactory.getDataSourceFactory(cattr, props);
        JDBCDiskCacheUnitTest.assertNotNull((String)"Should have a data source factory class", (Object)result);
        JDBCDiskCacheUnitTest.assertEquals((String)"wrong name", (String)poolName, (String)result.getName());
        System.setProperty("hsqldb.cache_scale", "8");
        String rafroot = "target";
        String database = rafroot + "/cache_hsql_db";
        new jdbcDriver();
        Class.forName(driverClassName).newInstance();
        Connection cConn = DriverManager.getConnection(url + database, userName, password);
        HsqlSetupTableUtil.setupTABLE(cConn, "JCSTESTTABLE_InitializePoolAccess");
    }
}

