/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine.memory.lru;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.commons.jcs.JCS;
import org.apache.commons.jcs.access.CacheAccess;
import org.apache.commons.jcs.access.exception.CacheException;
import org.apache.commons.jcs.engine.CacheElement;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.jcs.engine.control.CompositeCacheManager;
import org.apache.commons.jcs.engine.memory.lru.LHMLRUMemoryCache;

public class LHMLRUMemoryCacheUnitTest
extends TestCase {
    public void setUp() {
        JCS.setConfigFilename((String)"/TestLHMLRUCache.ccf");
    }

    public void testLoadFromCCF() throws CacheException {
        CacheAccess cache = JCS.getInstance((String)"testLoadFromCCF");
        String memoryCacheName = cache.getCacheAttributes().getMemoryCacheName();
        LHMLRUMemoryCacheUnitTest.assertTrue((String)"Cache name should have LHMLRU in it.", (memoryCacheName.indexOf("LHMLRUMemoryCache") != -1 ? 1 : 0) != 0);
    }

    public void testPutGetThroughHub() throws CacheException {
        int i;
        String value;
        int i2;
        CacheAccess cache = JCS.getInstance((String)"testPutGetThroughHub");
        int max = cache.getCacheAttributes().getMaxObjects();
        int items = max * 2;
        for (i2 = 0; i2 < items; ++i2) {
            cache.put((Object)(i2 + ":key"), (Object)("myregion data " + i2));
        }
        for (i2 = max - 1; i2 >= 0; --i2) {
            value = (String)cache.get((Object)(i2 + ":key"));
            LHMLRUMemoryCacheUnitTest.assertNull((String)("Should not have value for key [" + i2 + ":key" + "] in the cache." + cache.getStats()), (Object)value);
        }
        for (i2 = max + 2; i2 < items; ++i2) {
            value = (String)cache.get((Object)(i2 + ":key"));
            LHMLRUMemoryCacheUnitTest.assertEquals((String)("myregion data " + i2), (String)value);
        }
        HashSet<String> keys = new HashSet<String>();
        for (int i3 = 0; i3 < items; ++i3) {
            keys.add(i3 + ":key");
        }
        Map elements = cache.getCacheElements(keys);
        for (i = max - 1; i >= 0; --i) {
            LHMLRUMemoryCacheUnitTest.assertNull((String)("Should not have value for key [" + i + ":key" + "] in the cache." + cache.getStats()), elements.get(i + ":key"));
        }
        for (i = max + 2; i < items; ++i) {
            ICacheElement element = (ICacheElement)elements.get(i + ":key");
            LHMLRUMemoryCacheUnitTest.assertNotNull((String)("element " + i + ":key is missing"), (Object)element);
            LHMLRUMemoryCacheUnitTest.assertEquals((String)("value " + i + ":key"), (String)("myregion data " + i), (String)((String)element.getVal()));
        }
    }

    public void testPutGetThroughHubTwice() throws CacheException {
        String value;
        int i;
        CacheAccess cache = JCS.getInstance((String)"testPutGetThroughHubTwice");
        int max = cache.getCacheAttributes().getMaxObjects();
        int items = max * 2;
        for (i = 0; i < items; ++i) {
            cache.put((Object)(i + ":key"), (Object)("myregion data " + i));
        }
        for (i = 0; i < items; ++i) {
            cache.put((Object)(i + ":key"), (Object)("myregion data " + i));
        }
        for (i = max - 1; i >= 0; --i) {
            value = (String)cache.get((Object)(i + ":key"));
            LHMLRUMemoryCacheUnitTest.assertNull((String)("Should not have value for key [" + i + ":key" + "] in the cache."), (Object)value);
        }
        for (i = max + 2; i < items; ++i) {
            value = (String)cache.get((Object)(i + ":key"));
            LHMLRUMemoryCacheUnitTest.assertEquals((String)("myregion data " + i), (String)value);
        }
    }

    public void testPutRemoveThroughHub() throws CacheException {
        int i;
        CacheAccess cache = JCS.getInstance((String)"testPutRemoveThroughHub");
        int max = cache.getCacheAttributes().getMaxObjects();
        int items = max * 2;
        for (i = 0; i < items; ++i) {
            cache.put((Object)(i + ":key"), (Object)("myregion data " + i));
        }
        for (i = 0; i < items; ++i) {
            cache.remove((Object)(i + ":key"));
        }
        for (i = max; i >= 0; --i) {
            String value = (String)cache.get((Object)(i + ":key"));
            LHMLRUMemoryCacheUnitTest.assertNull((String)("Should not have value for key [" + i + ":key" + "] in the cache."), (Object)value);
        }
    }

    public void testClearThroughHub() throws CacheException {
        int i;
        CacheAccess cache = JCS.getInstance((String)"testClearThroughHub");
        int max = cache.getCacheAttributes().getMaxObjects();
        int items = max * 2;
        for (i = 0; i < items; ++i) {
            cache.put((Object)(i + ":key"), (Object)("myregion data " + i));
        }
        cache.clear();
        for (i = max; i >= 0; --i) {
            String value = (String)cache.get((Object)(i + ":key"));
            LHMLRUMemoryCacheUnitTest.assertNull((String)("Should not have value for key [" + i + ":key" + "] in the cache."), (Object)value);
        }
    }

    public void testGetStatsThroughHub() throws CacheException {
        CacheAccess cache = JCS.getInstance((String)"testGetStatsThroughHub");
        int max = cache.getCacheAttributes().getMaxObjects();
        int items = max * 2;
        for (int i = 0; i < items; ++i) {
            cache.put((Object)(i + ":key"), (Object)("myregion data " + i));
        }
        String stats = cache.getStats();
        LHMLRUMemoryCacheUnitTest.assertTrue((String)("Should have 200 puts" + stats), (stats.indexOf("200") != -1 ? 1 : 0) != 0);
    }

    public void testGetKeyArray() throws Exception {
        CompositeCacheManager cacheMgr = CompositeCacheManager.getUnconfiguredInstance();
        cacheMgr.configure("/TestLHMLRUCache.ccf");
        CompositeCache cache = cacheMgr.getCache("testGetKeyArray");
        LHMLRUMemoryCache mru = new LHMLRUMemoryCache();
        mru.initialize(cache);
        int max = cache.getCacheAttributes().getMaxObjects();
        int items = max / 2;
        for (int i = 0; i < items; ++i) {
            CacheElement ice = new CacheElement(cache.getCacheName(), (Object)(i + ":key"), (Object)(cache.getCacheName() + " data " + i));
            ice.setElementAttributes(cache.getElementAttributes());
            mru.update((ICacheElement)ice);
        }
        Set keys = mru.getKeySet();
        LHMLRUMemoryCacheUnitTest.assertEquals((String)"Wrong number of keys.", (int)items, (int)keys.size());
    }

    public void testRemovePartialThroughHub() throws CacheException {
        int i;
        CacheAccess cache = JCS.getInstance((String)"testRemovePartialThroughHub");
        int max = cache.getCacheAttributes().getMaxObjects();
        int items = max / 2;
        cache.put((Object)"test", (Object)"data");
        String root = "myroot";
        for (i = 0; i < items; ++i) {
            cache.put((Object)(root + ":" + i + ":key"), (Object)("myregion data " + i));
        }
        for (i = 0; i < items; ++i) {
            String value = (String)cache.get((Object)(root + ":" + i + ":key"));
            LHMLRUMemoryCacheUnitTest.assertEquals((String)("myregion data " + i), (String)value);
        }
        cache.remove((Object)(root + ":"));
        for (i = 0; i < items; ++i) {
            LHMLRUMemoryCacheUnitTest.assertNull((String)"Should have been removed by partial loop.", (Object)cache.get((Object)(root + ":" + i + ":key")));
        }
        LHMLRUMemoryCacheUnitTest.assertNotNull((String)"Other item should be in the cache.", (Object)cache.get((Object)"test"));
    }
}

