/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.threadpool;

import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.ThreadPoolExecutor;
import junit.framework.TestCase;
import org.apache.commons.jcs.utils.props.PropertyLoader;
import org.apache.commons.jcs.utils.threadpool.ThreadPoolManager;

public class ThreadPoolManagerUnitTest
extends TestCase {
    public void testDefaultConfig() {
        Properties props = PropertyLoader.loadProperties((String)"thread_pool.properties");
        ThreadPoolManager.setProps((Properties)props);
        ThreadPoolManager mgr = ThreadPoolManager.getInstance();
        ThreadPoolManagerUnitTest.assertNotNull((Object)mgr);
        ThreadPoolExecutor pool = mgr.getPool("test1");
        ThreadPoolManagerUnitTest.assertNotNull((Object)pool);
        int poolSize = pool.getPoolSize();
        int expectedPoolSize = Integer.parseInt(props.getProperty("thread_pool.test1.startUpSize"));
        ThreadPoolManagerUnitTest.assertEquals((int)poolSize, (int)expectedPoolSize);
        int max = pool.getMaximumPoolSize();
        int expected = Integer.parseInt(props.getProperty("thread_pool.test1.maximumPoolSize"));
        ThreadPoolManagerUnitTest.assertEquals((int)expected, (int)max);
    }

    public void testDefaultConfigUndefinedPool() {
        Properties props = PropertyLoader.loadProperties((String)"thread_pool.properties");
        ThreadPoolManager.setProps((Properties)props);
        ThreadPoolManager mgr = ThreadPoolManager.getInstance();
        ThreadPoolManagerUnitTest.assertNotNull((Object)mgr);
        ThreadPoolExecutor pool = mgr.getPool("doesnotexist");
        ThreadPoolManagerUnitTest.assertNotNull((Object)pool);
        int max = pool.getMaximumPoolSize();
        int expected = Integer.parseInt(props.getProperty("thread_pool.default.maximumPoolSize"));
        ThreadPoolManagerUnitTest.assertEquals((int)expected, (int)max);
    }

    public void testGetPoolNames() {
        ThreadPoolManager mgr = ThreadPoolManager.getInstance();
        ThreadPoolManagerUnitTest.assertNotNull((Object)mgr);
        String poolName1 = "testGetPoolNames1";
        mgr.getPool(poolName1);
        String poolName2 = "testGetPoolNames2";
        mgr.getPool(poolName2);
        ArrayList names = mgr.getPoolNames();
        ThreadPoolManagerUnitTest.assertTrue((String)"Should have name in list.", (boolean)names.contains(poolName1));
        ThreadPoolManagerUnitTest.assertTrue((String)"Should have name in list.", (boolean)names.contains(poolName2));
    }
}

