/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine.memory.soft;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.jcs.engine.control.group.GroupAttrName;
import org.apache.commons.jcs.engine.memory.AbstractMemoryCache;
import org.apache.commons.jcs.engine.memory.util.MemoryElementDescriptor;
import org.apache.commons.jcs.engine.memory.util.SoftReferenceElementDescriptor;
import org.apache.commons.jcs.engine.stats.StatElement;
import org.apache.commons.jcs.engine.stats.Stats;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SoftReferenceMemoryCache<K, V>
extends AbstractMemoryCache<K, V> {
    private static final Log log = LogFactory.getLog(SoftReferenceMemoryCache.class);
    private LinkedBlockingQueue<ICacheElement<K, V>> strongReferences;
    private AtomicLong hitCnt;
    private AtomicLong missCnt;
    private AtomicLong putCnt;

    @Override
    public synchronized void initialize(CompositeCache<K, V> hub) {
        super.initialize(hub);
        this.strongReferences = new LinkedBlockingQueue();
        this.hitCnt = new AtomicLong(0L);
        this.missCnt = new AtomicLong(0L);
        this.putCnt = new AtomicLong(0L);
        log.info((Object)("initialized Soft Reference Memory Cache for " + this.getCacheName()));
    }

    @Override
    public Map<K, MemoryElementDescriptor<K, V>> createMap() {
        return new ConcurrentHashMap();
    }

    @Override
    public Set<K> getKeySet() {
        HashSet keys = new HashSet();
        for (Map.Entry e : this.map.entrySet()) {
            SoftReferenceElementDescriptor sred = (SoftReferenceElementDescriptor)e.getValue();
            if (sred.getCacheElement() == null) continue;
            keys.add(e.getKey());
        }
        return keys;
    }

    @Override
    public int getSize() {
        int size = 0;
        for (MemoryElementDescriptor me : this.map.values()) {
            SoftReferenceElementDescriptor sred = (SoftReferenceElementDescriptor)me;
            if (sred.getCacheElement() == null) continue;
            ++size;
        }
        return size;
    }

    @Override
    public IStats getStatistics() {
        ArrayList elems = new ArrayList();
        int size = this.getSize();
        int emptyrefs = this.map.size() - size;
        elems.add(new StatElement<Integer>("Size", size));
        elems.add(new StatElement<Integer>("Empty References", emptyrefs));
        elems.add(new StatElement<Integer>("Strong References", this.strongReferences.size()));
        elems.add(new StatElement<AtomicLong>("Put Count", this.putCnt));
        elems.add(new StatElement<AtomicLong>("Hit Count", this.hitCnt));
        elems.add(new StatElement<AtomicLong>("Miss Count", this.missCnt));
        Stats stats = new Stats();
        stats.setTypeName("Soft Reference Memory Cache");
        stats.setStatElements(elems);
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean remove(K key) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removing item for key: " + key));
        }
        boolean removed = false;
        if (key instanceof String && ((String)key).endsWith(":")) {
            Iterator itr = this.map.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                Object k = entry.getKey();
                if (!(k instanceof String) || !((String)k).startsWith(key.toString())) continue;
                this.lock.lock();
                try {
                    this.strongReferences.remove(((MemoryElementDescriptor)entry.getValue()).getCacheElement());
                    itr.remove();
                    removed = true;
                }
                finally {
                    this.lock.unlock();
                }
            }
            return removed;
        } else if (key instanceof GroupAttrName && ((GroupAttrName)key).attrName == null) {
            Iterator itr = this.map.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                Object k = entry.getKey();
                if (!(k instanceof GroupAttrName) || !((GroupAttrName)k).groupId.equals(((GroupAttrName)key).groupId)) continue;
                this.lock.lock();
                try {
                    this.strongReferences.remove(((MemoryElementDescriptor)entry.getValue()).getCacheElement());
                    itr.remove();
                    removed = true;
                }
                finally {
                    this.lock.unlock();
                }
            }
            return removed;
        } else {
            this.lock.lock();
            try {
                MemoryElementDescriptor me = (MemoryElementDescriptor)this.map.remove(key);
                if (me == null) return removed;
                this.strongReferences.remove(me.getCacheElement());
                removed = true;
                return removed;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void removeAll() throws IOException {
        super.removeAll();
        this.strongReferences.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(ICacheElement<K, V> ce) throws IOException {
        this.putCnt.incrementAndGet();
        ce.getElementAttributes().setLastAccessTimeNow();
        this.lock.lock();
        try {
            this.map.put(ce.getKey(), new SoftReferenceElementDescriptor<K, V>(ce));
            this.strongReferences.add(ce);
            this.trimStrongReferences();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void trimStrongReferences() throws IOException {
        int startsize;
        int max = this.getCacheAttributes().getMaxObjects();
        for (int cursize = startsize = this.strongReferences.size(); cursize > max; --cursize) {
            ICacheElement<K, V> ce = this.strongReferences.poll();
            this.waterfal(ce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICacheElement<K, V> get(K key) throws IOException {
        ICacheElement val = null;
        this.lock.lock();
        try {
            val = this.getQuiet(key);
            if (val != null) {
                val.getElementAttributes().setLastAccessTimeNow();
                this.strongReferences.add(val);
                this.trimStrongReferences();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (val == null) {
            this.missCnt.incrementAndGet();
        } else {
            this.hitCnt.incrementAndGet();
        }
        return val;
    }

    @Override
    public void dispose() throws IOException {
        super.dispose();
        this.removeAll();
        this.hitCnt.set(0L);
        this.missCnt.set(0L);
        this.putCnt.set(0L);
    }

    @Override
    public int freeElements(int numberToFree) throws IOException {
        return 0;
    }
}

