/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk.block;

import java.io.File;
import java.io.Serializable;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.jcs.auxiliary.disk.block.BlockDisk;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.utils.serialization.StandardSerializer;

public class BlockDiskUnitTest
extends TestCase {
    private File rafDir;

    public BlockDiskUnitTest() {
        String rootDirName = "target/test-sandbox/block";
        this.rafDir = new File(rootDirName);
        this.rafDir.mkdirs();
    }

    public void testWrite_NullBlockElement() throws Exception {
        String fileName = "testWrite_NullBlockElement";
        File file = new File(this.rafDir, fileName + ".data");
        file.delete();
        BlockDisk disk = new BlockDisk(file, (IElementSerializer)new StandardSerializer());
        int[] blocks = disk.write(null);
        BlockDiskUnitTest.assertEquals((String)"Wrong number of blocks recorded.", (int)1, (int)disk.getNumberOfBlocks());
        BlockDiskUnitTest.assertEquals((String)"Wrong number of blocks returned.", (int)1, (int)blocks.length);
        BlockDiskUnitTest.assertEquals((String)"Wrong block returned.", (int)0, (int)blocks[0]);
    }

    public void testWrite_SingleBlockElement() throws Exception {
        String fileName = "testWrite_SingleBlockElement";
        File file = new File(this.rafDir, fileName + ".data");
        file.delete();
        BlockDisk disk = new BlockDisk(file, (IElementSerializer)new StandardSerializer());
        int bytes = 1024;
        int[] blocks = disk.write((Serializable)new byte[bytes]);
        BlockDiskUnitTest.assertEquals((String)"Wrong number of blocks recorded.", (int)1, (int)disk.getNumberOfBlocks());
        BlockDiskUnitTest.assertEquals((String)"Wrong number of blocks returned.", (int)1, (int)blocks.length);
        BlockDiskUnitTest.assertEquals((String)"Wrong block returned.", (int)0, (int)blocks[0]);
    }

    public void testWriteAndRead_SingleBlockElement() throws Exception {
        String fileName = "testWriteAndRead_SingleBlockElement";
        File file = new File(this.rafDir, fileName + ".data");
        file.delete();
        BlockDisk disk = new BlockDisk(file, (IElementSerializer)new StandardSerializer());
        int bytes = 1024;
        int[] blocks = disk.write((Serializable)new byte[bytes]);
        byte[] result = (byte[])disk.read(blocks);
        BlockDiskUnitTest.assertEquals((String)"Wrong item retured.", (int)new byte[bytes].length, (int)result.length);
    }

    public void testWrite_TwoSingleBlockElements() throws Exception {
        String fileName = "testWrite_TwoSingleBlockElements";
        File file = new File(this.rafDir, fileName + ".data");
        file.delete();
        BlockDisk disk = new BlockDisk(file, (IElementSerializer)new StandardSerializer());
        int bytes = 1024;
        int[] blocks1 = disk.write((Serializable)new byte[bytes]);
        int[] blocks2 = disk.write((Serializable)new byte[bytes]);
        BlockDiskUnitTest.assertEquals((String)"Wrong number of blocks recorded.", (int)2, (int)disk.getNumberOfBlocks());
        BlockDiskUnitTest.assertEquals((String)"Wrong number of blocks returned.", (int)1, (int)blocks1.length);
        BlockDiskUnitTest.assertEquals((String)"Wrong block returned.", (int)0, (int)blocks1[0]);
        BlockDiskUnitTest.assertEquals((String)"Wrong number of blocks returned.", (int)1, (int)blocks2.length);
        BlockDiskUnitTest.assertEquals((String)"Wrong block returned.", (int)1, (int)blocks2[0]);
    }

    public void testCalculateBlocksNeededDouble() throws Exception {
        String fileName = "testCalculateBlocksNeededDouble";
        File file = new File(this.rafDir, fileName + ".data");
        file.delete();
        BlockDisk disk = new BlockDisk(file, (IElementSerializer)new StandardSerializer());
        int result = disk.calculateTheNumberOfBlocksNeeded(new byte[disk.getBlockSizeBytes() * 2 - 8]);
        BlockDiskUnitTest.assertEquals((String)"Wrong number of blocks", (int)2, (int)result);
    }

    public void testWrite_DoubleBlockElement() throws Exception {
        String fileName = "testWriteDoubleBlockElement";
        File file = new File(this.rafDir, fileName + ".data");
        BlockDisk disk = new BlockDisk(file, (IElementSerializer)new StandardSerializer());
        int bytes = this.getBytesForBlocksOfByteArrays(disk.getBlockSizeBytes(), 2);
        int[] blocks = disk.write((Serializable)new byte[bytes]);
        BlockDiskUnitTest.assertEquals((String)"Wrong number of blocks recorded.", (int)2, (int)disk.getNumberOfBlocks());
        BlockDiskUnitTest.assertEquals((String)"Wrong number of blocks returned.", (int)2, (int)blocks.length);
        BlockDiskUnitTest.assertEquals((String)"Wrong block returned.", (int)0, (int)blocks[0]);
    }

    public void testWrite_128BlockElement() throws Exception {
        int numBlocks = 128;
        String fileName = "testWrite_128BlockElement";
        File file = new File(this.rafDir, fileName + ".data");
        BlockDisk disk = new BlockDisk(file, (IElementSerializer)new StandardSerializer());
        int bytes = this.getBytesForBlocksOfByteArrays(disk.getBlockSizeBytes(), numBlocks);
        int[] blocks = disk.write((Serializable)new byte[bytes]);
        BlockDiskUnitTest.assertEquals((String)"Wrong number of blocks recorded.", (int)numBlocks, (int)disk.getNumberOfBlocks());
        BlockDiskUnitTest.assertEquals((String)"Wrong number of blocks returned.", (int)numBlocks, (int)blocks.length);
        BlockDiskUnitTest.assertEquals((String)"Wrong block returned.", (int)0, (int)blocks[0]);
    }

    public void testWriteAndReadMultipleMultiBlockElement() throws Exception {
        String fileName = "testWriteAndReadSingleBlockElement";
        File file = new File(this.rafDir, fileName + ".data");
        file.delete();
        BlockDisk disk = new BlockDisk(file, (IElementSerializer)new StandardSerializer());
        int numBlocksPerElement = 4;
        int bytes = this.getBytesForBlocksOfByteArrays(disk.getBlockSizeBytes(), numBlocksPerElement);
        int numElements = 100;
        for (int i = 0; i < numElements; ++i) {
            int[] blocks = disk.write((Serializable)new byte[bytes]);
            byte[] result = (byte[])disk.read(blocks);
            BlockDiskUnitTest.assertEquals((String)"Wrong item retured.", (int)new byte[bytes].length, (int)result.length);
            BlockDiskUnitTest.assertEquals((String)"Wrong number of blocks returned.", (int)numBlocksPerElement, (int)blocks.length);
        }
    }

    public void testWriteAndReadMultipleMultiBlockElement_setSize() throws Exception {
        String fileName = "testWriteAndReadSingleBlockElement";
        File file = new File(this.rafDir, fileName + ".data");
        file.delete();
        int blockSizeBytes = 1024;
        BlockDisk disk = new BlockDisk(file, blockSizeBytes);
        int numBlocksPerElement = 4;
        int bytes = this.getBytesForBlocksOfByteArrays(disk.getBlockSizeBytes(), numBlocksPerElement);
        int numElements = 100;
        Random r = new Random(System.currentTimeMillis());
        byte[] src = new byte[bytes];
        for (int i = 0; i < numElements; ++i) {
            r.nextBytes(src);
            int[] blocks = disk.write((Serializable)src);
            byte[] result = (byte[])disk.read(blocks);
            BlockDiskUnitTest.assertEquals((String)"Wrong item length retured.", (int)src.length, (int)result.length);
            BlockDiskUnitTest.assertEquals((String)"Wrong number of blocks returned.", (int)numBlocksPerElement, (int)blocks.length);
            for (int j = 0; j < src.length; ++j) {
                BlockDiskUnitTest.assertEquals((String)("Mismatch at offset " + j + " in attempt # " + (i + 1)), (byte)src[j], (byte)result[j]);
            }
        }
        BlockDiskUnitTest.assertEquals((String)("Wrong number of elements. " + disk), (int)(numBlocksPerElement * numElements), (int)disk.getNumberOfBlocks());
    }

    private int getBytesForBlocksOfByteArrays(int blockSize, int numBlocks) {
        return blockSize * numBlocks - numBlocks * 4 - numBlocks * 14;
    }

    public void testWriteAndRead_BigString() throws Exception {
        String fileName = "testWriteAndRead_BigString";
        File file = new File(this.rafDir, fileName + ".data");
        file.delete();
        int blockSizeBytes = 4096;
        BlockDisk disk = new BlockDisk(file, blockSizeBytes, (IElementSerializer)new StandardSerializer());
        String string = "This is my big string ABCDEFGH";
        StringBuilder sb = new StringBuilder();
        sb.append(string);
        for (int i = 0; i < 8; ++i) {
            sb.append(" " + i + sb.toString());
        }
        string = sb.toString();
        int[] blocks = disk.write((Serializable)((Object)string));
        String result = (String)((Object)disk.read(blocks));
        BlockDiskUnitTest.assertEquals((String)"Wrong item retured.", (String)string, (String)result);
    }

    public void testWriteAndRead_BigString2() throws Exception {
        String fileName = "testWriteAndRead_BigString";
        File file = new File(this.rafDir, fileName + ".data");
        file.delete();
        int blockSizeBytes = 47;
        BlockDisk disk = new BlockDisk(file, blockSizeBytes, (IElementSerializer)new StandardSerializer());
        String string = "abcdefghijklmnopqrstuvwxyz1234567890";
        string = string + string;
        string = string + string;
        int[] blocks = disk.write((Serializable)((Object)string));
        String result = (String)((Object)disk.read(blocks));
        BlockDiskUnitTest.assertEquals((String)"Wrong item retured.", (String)string, (String)result);
    }

    public void testJCS156() throws Exception {
        String fileName = "testJCS156";
        File file = new File(this.rafDir, fileName + ".data");
        file.delete();
        int blockSizeBytes = 4096;
        BlockDisk disk = new BlockDisk(file, blockSizeBytes, (IElementSerializer)new StandardSerializer());
        long offset = disk.calculateByteOffsetForBlockAsLong(Integer.MAX_VALUE);
        BlockDiskUnitTest.assertTrue((String)"Must not wrap round", (offset > 0L ? 1 : 0) != 0);
        BlockDiskUnitTest.assertEquals((long)0x7FFFFFFF000L, (long)offset);
        file.delete();
    }
}

