/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk.indexed;

import junit.framework.TestCase;
import org.apache.commons.jcs.auxiliary.disk.indexed.IndexedDiskCache;
import org.apache.commons.jcs.auxiliary.disk.indexed.IndexedDiskCacheAttributes;
import org.apache.commons.jcs.engine.CacheElement;
import org.apache.commons.jcs.engine.ElementAttributes;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.IElementAttributes;

public class IndexedDiskCacheKeyStoreUnitTest
extends TestCase {
    public void testStoreKeys() throws Exception {
        ICacheElement element;
        int i;
        IndexedDiskCacheAttributes cattr = new IndexedDiskCacheAttributes();
        cattr.setCacheName("testStoreKeys");
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/KeyStoreUnitTest");
        IndexedDiskCache disk = new IndexedDiskCache(cattr);
        disk.processRemoveAll();
        int cnt = 25;
        for (i = 0; i < cnt; ++i) {
            ElementAttributes eAttr = new ElementAttributes();
            eAttr.setIsSpool(true);
            CacheElement element2 = new CacheElement(cattr.getCacheName(), (Object)("key:" + i), (Object)("data:" + i));
            element2.setElementAttributes((IElementAttributes)eAttr);
            disk.processUpdate((ICacheElement)element2);
        }
        for (i = 0; i < cnt; ++i) {
            element = disk.processGet((Object)("key:" + i));
            IndexedDiskCacheKeyStoreUnitTest.assertNotNull((String)"presave, Should have received an element.", (Object)element);
            IndexedDiskCacheKeyStoreUnitTest.assertEquals((String)"presave, element is wrong.", (String)("data:" + i), (String)((String)element.getVal()));
        }
        disk.saveKeys();
        disk.loadKeys();
        IndexedDiskCacheKeyStoreUnitTest.assertEquals((String)"The disk is the wrong size.", (int)cnt, (int)disk.getSize());
        for (i = 0; i < cnt; ++i) {
            element = disk.processGet((Object)("key:" + i));
            IndexedDiskCacheKeyStoreUnitTest.assertNotNull((String)"postsave, Should have received an element.", (Object)element);
            IndexedDiskCacheKeyStoreUnitTest.assertEquals((String)"postsave, element is wrong.", (String)("data:" + i), (String)((String)element.getVal()));
        }
        disk.dump();
    }

    public void testOptiimize() throws Exception {
        IndexedDiskCacheAttributes cattr = new IndexedDiskCacheAttributes();
        cattr.setCacheName("testOptimize");
        cattr.setMaxKeySize(100);
        cattr.setDiskPath("target/test-sandbox/KeyStoreUnitTest");
        IndexedDiskCache disk = new IndexedDiskCache(cattr);
        disk.processRemoveAll();
        int cnt = 25;
        for (int i = 0; i < cnt; ++i) {
            ElementAttributes eAttr = new ElementAttributes();
            eAttr.setIsSpool(true);
            CacheElement element = new CacheElement(cattr.getCacheName(), (Object)("key:" + i), (Object)("data:" + i));
            element.setElementAttributes((IElementAttributes)eAttr);
            disk.processUpdate((ICacheElement)element);
        }
        long preAddRemoveSize = disk.getDataFileSize();
        ElementAttributes eAttr = new ElementAttributes();
        eAttr.setIsSpool(true);
        CacheElement elementSetup = new CacheElement(cattr.getCacheName(), (Object)"key:A", (Object)"data:A");
        elementSetup.setElementAttributes((IElementAttributes)eAttr);
        disk.processUpdate((ICacheElement)elementSetup);
        ICacheElement elementRet = disk.processGet((Object)"key:A");
        IndexedDiskCacheKeyStoreUnitTest.assertNotNull((String)"postsave, Should have received an element.", (Object)elementRet);
        IndexedDiskCacheKeyStoreUnitTest.assertEquals((String)"postsave, element is wrong.", (String)"data:A", (String)((String)elementRet.getVal()));
        disk.remove((Object)"key:A");
        long preSize = disk.getDataFileSize();
        disk.optimizeFile();
        long postSize = disk.getDataFileSize();
        IndexedDiskCacheKeyStoreUnitTest.assertTrue((String)("Should be smaller. postsize=" + postSize + " preSize=" + preSize), (postSize < preSize ? 1 : 0) != 0);
        IndexedDiskCacheKeyStoreUnitTest.assertEquals((String)"Should be the same size after optimization as before add and remove.", (long)preAddRemoveSize, (long)postSize);
        for (int i = 0; i < cnt; ++i) {
            ICacheElement element = disk.processGet((Object)("key:" + i));
            IndexedDiskCacheKeyStoreUnitTest.assertNotNull((String)"postsave, Should have received an element.", (Object)element);
            IndexedDiskCacheKeyStoreUnitTest.assertEquals((String)"postsave, element is wrong.", (String)("data:" + i), (String)((String)element.getVal()));
        }
    }
}

