/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.lateral;

import junit.framework.TestCase;
import org.apache.commons.jcs.auxiliary.lateral.LateralCache;
import org.apache.commons.jcs.auxiliary.lateral.LateralCacheAttributes;
import org.apache.commons.jcs.auxiliary.lateral.LateralCacheNoWait;
import org.apache.commons.jcs.auxiliary.lateral.LateralCacheNoWaitFacade;
import org.apache.commons.jcs.auxiliary.lateral.behavior.ILateralCacheAttributes;

public class LateralCacheNoWaitFacadeUnitTest
extends TestCase {
    public void testAddThenRemoveNoWait_InList() {
        LateralCacheNoWait[] noWaits = new LateralCacheNoWait[]{};
        LateralCacheAttributes cattr = new LateralCacheAttributes();
        cattr.setCacheName("testCache1");
        LateralCacheNoWaitFacade facade = new LateralCacheNoWaitFacade(null, noWaits, (ILateralCacheAttributes)cattr);
        LateralCache cache = new LateralCache((ILateralCacheAttributes)cattr);
        LateralCacheNoWait noWait = new LateralCacheNoWait(cache);
        facade.addNoWait(noWait);
        LateralCacheNoWaitFacadeUnitTest.assertTrue((String)"Should be in the list.", (boolean)facade.containsNoWait(noWait));
        facade.removeNoWait(noWait);
        LateralCacheNoWaitFacadeUnitTest.assertEquals((String)"Should have 0", (int)0, (int)facade.noWaits.length);
        LateralCacheNoWaitFacadeUnitTest.assertFalse((String)"Should not be in the list. ", (boolean)facade.containsNoWait(noWait));
    }

    public void testAddThenRemoveNoWait_InListSize2() {
        LateralCacheNoWait[] noWaits = new LateralCacheNoWait[]{};
        LateralCacheAttributes cattr = new LateralCacheAttributes();
        cattr.setCacheName("testCache1");
        LateralCacheNoWaitFacade facade = new LateralCacheNoWaitFacade(null, noWaits, (ILateralCacheAttributes)cattr);
        LateralCache cache = new LateralCache((ILateralCacheAttributes)cattr);
        LateralCacheNoWait noWait = new LateralCacheNoWait(cache);
        LateralCacheNoWait noWait2 = new LateralCacheNoWait(cache);
        facade.addNoWait(noWait);
        facade.addNoWait(noWait2);
        LateralCacheNoWaitFacadeUnitTest.assertEquals((String)"Should have 2", (int)2, (int)facade.noWaits.length);
        LateralCacheNoWaitFacadeUnitTest.assertTrue((String)"Should be in the list.", (boolean)facade.containsNoWait(noWait));
        LateralCacheNoWaitFacadeUnitTest.assertTrue((String)"Should be in the list.", (boolean)facade.containsNoWait(noWait2));
        facade.removeNoWait(noWait);
        LateralCacheNoWaitFacadeUnitTest.assertEquals((String)"Should only have 1", (int)1, (int)facade.noWaits.length);
        LateralCacheNoWaitFacadeUnitTest.assertFalse((String)"Should not be in the list. ", (boolean)facade.containsNoWait(noWait));
        LateralCacheNoWaitFacadeUnitTest.assertTrue((String)"Should be in the list.", (boolean)facade.containsNoWait(noWait2));
    }

    public void testAdd_InList() {
        LateralCacheNoWait[] noWaits = new LateralCacheNoWait[]{};
        LateralCacheAttributes cattr = new LateralCacheAttributes();
        cattr.setCacheName("testCache1");
        LateralCacheNoWaitFacade facade = new LateralCacheNoWaitFacade(null, noWaits, (ILateralCacheAttributes)cattr);
        LateralCache cache = new LateralCache((ILateralCacheAttributes)cattr);
        LateralCacheNoWait noWait = new LateralCacheNoWait(cache);
        facade.addNoWait(noWait);
        facade.addNoWait(noWait);
        LateralCacheNoWaitFacadeUnitTest.assertTrue((String)"Should be in the list.", (boolean)facade.containsNoWait(noWait));
        LateralCacheNoWaitFacadeUnitTest.assertEquals((String)"Should only have 1", (int)1, (int)facade.noWaits.length);
    }

    public void testAddThenRemoveNoWait_NotInList() {
        LateralCacheNoWait[] noWaits = new LateralCacheNoWait[]{};
        LateralCacheAttributes cattr = new LateralCacheAttributes();
        cattr.setCacheName("testCache1");
        LateralCacheNoWaitFacade facade = new LateralCacheNoWaitFacade(null, noWaits, (ILateralCacheAttributes)cattr);
        LateralCache cache = new LateralCache((ILateralCacheAttributes)cattr);
        LateralCacheNoWait noWait = new LateralCacheNoWait(cache);
        facade.removeNoWait(noWait);
        LateralCacheNoWaitFacadeUnitTest.assertFalse((String)"Should not be in the list.", (boolean)facade.containsNoWait(noWait));
    }
}

