/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote;

import java.rmi.registry.Registry;
import junit.framework.TestCase;
import org.apache.commons.jcs.auxiliary.remote.RemoteLocation;
import org.apache.commons.jcs.auxiliary.remote.RemoteUtils;

public class RemoteUtilsUnitTest
extends TestCase {
    public void testCreateRegistry() {
        Registry registry = RemoteUtils.createRegistry((int)1102);
        RemoteUtilsUnitTest.assertNotNull((String)"Registry should not be null", (Object)registry);
    }

    public void testGetNamingURL() {
        RemoteUtilsUnitTest.assertEquals((String)"//host:1/servicename", (String)RemoteUtils.getNamingURL((String)"host", (int)1, (String)"servicename"));
        RemoteUtilsUnitTest.assertEquals((String)"//127.0.0.1:2/servicename", (String)RemoteUtils.getNamingURL((String)"127.0.0.1", (int)2, (String)"servicename"));
        RemoteUtilsUnitTest.assertEquals((String)"//[0:0:0:0:0:0:0:1%251]:3/servicename", (String)RemoteUtils.getNamingURL((String)"0:0:0:0:0:0:0:1%1", (int)3, (String)"servicename"));
    }

    public void testParseServerAndPort() {
        RemoteLocation loc = RemoteLocation.parseServerAndPort((String)"server1:1234");
        RemoteUtilsUnitTest.assertEquals((String)"server1", (String)loc.getHost());
        RemoteUtilsUnitTest.assertEquals((int)1234, (int)loc.getPort());
        loc = RemoteLocation.parseServerAndPort((String)"  server2  :  4567  ");
        RemoteUtilsUnitTest.assertEquals((String)"server2", (String)loc.getHost());
        RemoteUtilsUnitTest.assertEquals((int)4567, (int)loc.getPort());
        loc = RemoteLocation.parseServerAndPort((String)"server2  :  port");
        RemoteUtilsUnitTest.assertNull((Object)loc);
    }
}

