/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine.memory.soft;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.commons.jcs.JCS;
import org.apache.commons.jcs.access.CacheAccess;
import org.apache.commons.jcs.access.exception.CacheException;
import org.apache.commons.jcs.engine.CacheElement;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.jcs.engine.control.CompositeCacheManager;
import org.apache.commons.jcs.engine.memory.soft.SoftReferenceMemoryCache;

public class SoftReferenceMemoryCacheUnitTest
extends TestCase {
    public void setUp() {
        JCS.setConfigFilename((String)"/TestSoftReferenceCache.ccf");
    }

    protected void tearDown() throws Exception {
        CompositeCacheManager.getInstance().shutDown();
    }

    public void testLoadFromCCF() throws CacheException {
        CacheAccess cache = JCS.getInstance((String)"testPutGet");
        String memoryCacheName = cache.getCacheAttributes().getMemoryCacheName();
        SoftReferenceMemoryCacheUnitTest.assertTrue((String)"Cache name should have SoftReference in it.", (memoryCacheName.indexOf("SoftReferenceMemoryCache") != -1 ? 1 : 0) != 0);
    }

    public void testPutGetThroughHub() throws CacheException {
        int i;
        CacheAccess cache = JCS.getInstance((String)"testPutGetThroughHub");
        int max = cache.getCacheAttributes().getMaxObjects();
        int items = max * 2;
        for (i = 0; i < items; ++i) {
            cache.put((Object)(i + ":key"), (Object)("myregion data " + i));
        }
        for (i = 0; i < items; ++i) {
            String value = (String)cache.get((Object)(i + ":key"));
            SoftReferenceMemoryCacheUnitTest.assertEquals((String)("myregion data " + i), (String)value);
        }
        HashSet<String> keys = new HashSet<String>();
        for (int i2 = 0; i2 < items; ++i2) {
            keys.add(i2 + ":key");
        }
        Map elements = cache.getCacheElements(keys);
        for (int i3 = 0; i3 < items; ++i3) {
            ICacheElement element = (ICacheElement)elements.get(i3 + ":key");
            SoftReferenceMemoryCacheUnitTest.assertNotNull((String)("element " + i3 + ":key is missing"), (Object)element);
            SoftReferenceMemoryCacheUnitTest.assertEquals((String)("value " + i3 + ":key"), (String)("myregion data " + i3), (String)((String)element.getVal()));
        }
    }

    public void testPutRemoveThroughHub() throws CacheException {
        int i;
        CacheAccess cache = JCS.getInstance((String)"testPutGetThroughHub");
        int max = cache.getCacheAttributes().getMaxObjects();
        int items = max * 2;
        for (i = 0; i < items; ++i) {
            cache.put((Object)(i + ":key"), (Object)("myregion data " + i));
        }
        for (i = 0; i < items; ++i) {
            cache.remove((Object)(i + ":key"));
        }
        for (i = max; i >= 0; --i) {
            String value = (String)cache.get((Object)(i + ":key"));
            SoftReferenceMemoryCacheUnitTest.assertNull((String)("Should not have value for key [" + i + ":key" + "] in the cache."), (Object)value);
        }
    }

    public void testClearThroughHub() throws CacheException {
        int i;
        CacheAccess cache = JCS.getInstance((String)"testPutGetThroughHub");
        int max = cache.getCacheAttributes().getMaxObjects();
        int items = max * 2;
        for (i = 0; i < items; ++i) {
            cache.put((Object)(i + ":key"), (Object)("myregion data " + i));
        }
        cache.clear();
        for (i = max; i >= 0; --i) {
            String value = (String)cache.get((Object)(i + ":key"));
            SoftReferenceMemoryCacheUnitTest.assertNull((String)("Should not have value for key [" + i + ":key" + "] in the cache."), (Object)value);
        }
    }

    public void testGetKeyArray() throws Exception {
        CompositeCacheManager cacheMgr = CompositeCacheManager.getUnconfiguredInstance();
        cacheMgr.configure("/TestSoftReferenceCache.ccf");
        CompositeCache cache = cacheMgr.getCache("testGetKeyArray");
        SoftReferenceMemoryCache srmc = new SoftReferenceMemoryCache();
        srmc.initialize(cache);
        int max = cache.getCacheAttributes().getMaxObjects();
        int items = max / 2;
        for (int i = 0; i < items; ++i) {
            CacheElement ice = new CacheElement(cache.getCacheName(), (Object)(i + ":key"), (Object)(cache.getCacheName() + " data " + i));
            ice.setElementAttributes(cache.getElementAttributes());
            srmc.update((ICacheElement)ice);
        }
        Set keys = srmc.getKeySet();
        SoftReferenceMemoryCacheUnitTest.assertEquals((String)"Wrong number of keys.", (int)items, (int)keys.size());
    }

    public void testRemovePartialThroughHub() throws CacheException {
        int i;
        CacheAccess cache = JCS.getInstance((String)"testGetStatsThroughHub");
        int max = cache.getCacheAttributes().getMaxObjects();
        int items = max / 2;
        cache.put((Object)"test", (Object)"data");
        String root = "myroot";
        for (i = 0; i < items; ++i) {
            cache.put((Object)(root + ":" + i + ":key"), (Object)("myregion data " + i));
        }
        for (i = 0; i < items; ++i) {
            String value = (String)cache.get((Object)(root + ":" + i + ":key"));
            SoftReferenceMemoryCacheUnitTest.assertEquals((String)("myregion data " + i), (String)value);
        }
        cache.remove((Object)(root + ":"));
        for (i = 0; i < items; ++i) {
            SoftReferenceMemoryCacheUnitTest.assertNull((String)"Should have been removed by partial loop.", (Object)cache.get((Object)(root + ":" + i + ":key")));
        }
        SoftReferenceMemoryCacheUnitTest.assertNotNull((String)"Other item should be in the cache.", (Object)cache.get((Object)"test"));
    }
}

