/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.serialization;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.jcs.engine.CacheElement;
import org.apache.commons.jcs.engine.ElementAttributes;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICacheElementSerialized;
import org.apache.commons.jcs.engine.behavior.IElementAttributes;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.utils.serialization.SerializationConversionUtil;
import org.apache.commons.jcs.utils.serialization.StandardSerializer;

public class SerializationConversionUtilUnitTest
extends TestCase {
    public void testgGetSerializedCacheElement_null() throws IOException {
        StandardSerializer elementSerializer = new StandardSerializer();
        ICacheElement before = null;
        ICacheElementSerialized result = SerializationConversionUtil.getSerializedCacheElement(before, (IElementSerializer)elementSerializer);
        SerializationConversionUtilUnitTest.assertNull((String)"Should get null for null", (Object)result);
    }

    public void testgGetDeSerializedCacheElement_null() throws Exception {
        StandardSerializer elementSerializer = new StandardSerializer();
        ICacheElementSerialized before = null;
        ICacheElement result = SerializationConversionUtil.getDeSerializedCacheElement(before, (IElementSerializer)elementSerializer);
        SerializationConversionUtilUnitTest.assertNull((String)"Should get null for null", (Object)result);
    }

    public void testSimpleConversion() throws Exception {
        String cacheName = "testName";
        String key = "key";
        String value = "value fdsadf dsafdsa fdsaf dsafdsaf dsafdsaf dsaf dsaf dsaf dsafa dsaf dsaf dsafdsaf";
        StandardSerializer elementSerializer = new StandardSerializer();
        ElementAttributes attr = new ElementAttributes();
        attr.setMaxLife(34L);
        CacheElement before = new CacheElement(cacheName, (Object)key, (Object)value);
        before.setElementAttributes((IElementAttributes)attr);
        ICacheElementSerialized serialized = SerializationConversionUtil.getSerializedCacheElement((ICacheElement)before, (IElementSerializer)elementSerializer);
        SerializationConversionUtilUnitTest.assertNotNull((String)"Should have a serialized object.", (Object)serialized);
        ICacheElement after = SerializationConversionUtil.getDeSerializedCacheElement((ICacheElementSerialized)serialized, (IElementSerializer)elementSerializer);
        SerializationConversionUtilUnitTest.assertNotNull((String)"Should have a deserialized object.", (Object)after);
        SerializationConversionUtilUnitTest.assertEquals((String)"Values should be the same.", (String)((String)before.getVal()), (String)((String)after.getVal()));
        SerializationConversionUtilUnitTest.assertEquals((String)"Attributes should be the same.", (long)before.getElementAttributes().getMaxLife(), (long)after.getElementAttributes().getMaxLife());
        SerializationConversionUtilUnitTest.assertEquals((String)"Keys should be the same.", (String)((String)before.getKey()), (String)((String)after.getKey()));
        SerializationConversionUtilUnitTest.assertEquals((String)"Cache name should be the same.", (String)before.getCacheName(), (String)after.getCacheName());
    }

    public void testAccidentalDoubleConversion() throws Exception {
        String cacheName = "testName";
        String key = "key";
        String value = "value fdsadf dsafdsa fdsaf dsafdsaf dsafdsaf dsaf dsaf dsaf dsafa dsaf dsaf dsafdsaf";
        StandardSerializer elementSerializer = new StandardSerializer();
        ElementAttributes attr = new ElementAttributes();
        attr.setMaxLife(34L);
        CacheElement before = new CacheElement(cacheName, (Object)key, (Object)value);
        before.setElementAttributes((IElementAttributes)attr);
        ICacheElementSerialized alreadySerialized = SerializationConversionUtil.getSerializedCacheElement((ICacheElement)before, (IElementSerializer)elementSerializer);
        ICacheElementSerialized serialized = SerializationConversionUtil.getSerializedCacheElement((ICacheElement)alreadySerialized, (IElementSerializer)elementSerializer);
        SerializationConversionUtilUnitTest.assertNotNull((String)"Should have a serialized object.", (Object)serialized);
        ICacheElement after = SerializationConversionUtil.getDeSerializedCacheElement((ICacheElementSerialized)serialized, (IElementSerializer)elementSerializer);
        SerializationConversionUtilUnitTest.assertNotNull((String)"Should have a deserialized object.", (Object)after);
        SerializationConversionUtilUnitTest.assertEquals((String)"Values should be the same.", (String)((String)before.getVal()), (String)((String)after.getVal()));
        SerializationConversionUtilUnitTest.assertEquals((String)"Attributes should be the same.", (long)before.getElementAttributes().getMaxLife(), (long)after.getElementAttributes().getMaxLife());
        SerializationConversionUtilUnitTest.assertEquals((String)"Keys should be the same.", (String)((String)before.getKey()), (String)((String)after.getKey()));
        SerializationConversionUtilUnitTest.assertEquals((String)"Cache name should be the same.", (String)before.getCacheName(), (String)after.getCacheName());
    }

    public void testNullSerializerConversion() {
        String cacheName = "testName";
        String key = "key";
        String value = "value fdsadf dsafdsa fdsaf dsafdsaf dsafdsaf dsaf dsaf dsaf dsafa dsaf dsaf dsafdsaf";
        IElementSerializer elementSerializer = null;
        ElementAttributes attr = new ElementAttributes();
        attr.setMaxLife(34L);
        CacheElement before = new CacheElement(cacheName, (Object)key, (Object)value);
        before.setElementAttributes((IElementAttributes)attr);
        try {
            SerializationConversionUtil.getSerializedCacheElement((ICacheElement)before, elementSerializer);
            SerializationConversionUtilUnitTest.fail((String)"We should have received an IOException.");
        }
        catch (IOException e) {
            // empty catch block
        }
    }
}

