/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.jcache.extras.loader;

import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.Cache;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.integration.CacheLoaderException;
import org.apache.commons.jcs.jcache.extras.InternalCacheRule;
import org.apache.commons.jcs.jcache.extras.loader.CacheLoaderAdapter;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class CacheLoaderAdapterTest {
    @Rule
    public final InternalCacheRule rule = new InternalCacheRule(this);
    private final AtomicInteger count = new AtomicInteger(0);
    private final Configuration<?, ?> config = new MutableConfiguration().setStoreByValue(false).setReadThrough(true).setCacheLoaderFactory((Factory)new CacheLoaderAdapter<String, String>(){

        public String load(String key) throws CacheLoaderException {
            CacheLoaderAdapterTest.this.count.incrementAndGet();
            return key;
        }
    });
    private Cache<String, String> cache;

    @Test
    public void checkLoadAll() {
        Assert.assertFalse((boolean)this.cache.iterator().hasNext());
        Assert.assertEquals((Object)"foo", (Object)this.cache.get((Object)"foo"));
        this.count.decrementAndGet();
        this.cache.loadAll(new HashSet<String>(Arrays.asList("a", "b")), true, null);
        int retries = 100;
        while (retries-- > 0 && this.count.get() != 2) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
        Assert.assertEquals((long)2L, (long)this.count.get());
        Assert.assertEquals((Object)"a", (Object)this.cache.get((Object)"a"));
        Assert.assertEquals((Object)"b", (Object)this.cache.get((Object)"b"));
        Assert.assertEquals((long)2L, (long)this.count.get());
    }
}

