/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.lateral;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jcs.auxiliary.AbstractAuxiliaryCacheEventLogging;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs.auxiliary.lateral.LateralCacheMonitor;
import org.apache.commons.jcs.auxiliary.lateral.behavior.ILateralCacheAttributes;
import org.apache.commons.jcs.engine.CacheInfo;
import org.apache.commons.jcs.engine.CacheStatus;
import org.apache.commons.jcs.engine.ZombieCacheServiceNonLocal;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICacheServiceNonLocal;
import org.apache.commons.jcs.engine.behavior.ICacheType;
import org.apache.commons.jcs.engine.behavior.IZombie;
import org.apache.commons.jcs.engine.stats.Stats;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LateralCache<K, V>
extends AbstractAuxiliaryCacheEventLogging<K, V> {
    private static final Log log = LogFactory.getLog(LateralCache.class);
    private final ILateralCacheAttributes lateralCacheAttributes;
    final String cacheName;
    private ICacheServiceNonLocal<K, V> lateralCacheService;
    private LateralCacheMonitor monitor;

    public LateralCache(ILateralCacheAttributes cattr, ICacheServiceNonLocal<K, V> lateral, LateralCacheMonitor monitor) {
        this.cacheName = cattr.getCacheName();
        this.lateralCacheAttributes = cattr;
        this.lateralCacheService = lateral;
        this.monitor = monitor;
    }

    public LateralCache(ILateralCacheAttributes cattr) {
        this.cacheName = cattr.getCacheName();
        this.lateralCacheAttributes = cattr;
    }

    @Override
    protected void processUpdate(ICacheElement<K, V> ce) throws IOException {
        try {
            if (ce != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("update: lateral = [" + this.lateralCacheService + "], " + "CacheInfo.listenerId = " + CacheInfo.listenerId));
                }
                this.lateralCacheService.update(ce, CacheInfo.listenerId);
            }
        }
        catch (IOException ex) {
            this.handleException(ex, "Failed to put [" + ce.getKey() + "] to " + ce.getCacheName() + "@" + this.lateralCacheAttributes);
        }
    }

    @Override
    protected ICacheElement<K, V> processGet(K key) throws IOException {
        ICacheElement obj = null;
        if (this.lateralCacheAttributes.getPutOnlyMode()) {
            return null;
        }
        try {
            obj = this.lateralCacheService.get(this.cacheName, key);
        }
        catch (Exception e) {
            log.error((Object)e);
            this.handleException(e, "Failed to get [" + key + "] from " + this.lateralCacheAttributes.getCacheName() + "@" + this.lateralCacheAttributes);
        }
        return obj;
    }

    @Override
    protected Map<K, ICacheElement<K, V>> processGetMatching(String pattern) throws IOException {
        if (this.lateralCacheAttributes.getPutOnlyMode()) {
            return Collections.emptyMap();
        }
        try {
            return this.lateralCacheService.getMatching(this.cacheName, pattern);
        }
        catch (IOException e) {
            log.error((Object)e);
            this.handleException(e, "Failed to getMatching [" + pattern + "] from " + this.lateralCacheAttributes.getCacheName() + "@" + this.lateralCacheAttributes);
            return Collections.emptyMap();
        }
    }

    @Override
    protected Map<K, ICacheElement<K, V>> processGetMultiple(Set<K> keys) throws IOException {
        HashMap elements = new HashMap();
        if (keys != null && !keys.isEmpty()) {
            for (K key : keys) {
                ICacheElement element = this.get(key);
                if (element == null) continue;
                elements.put(key, element);
            }
        }
        return elements;
    }

    @Override
    public Set<K> getKeySet() throws IOException {
        try {
            return this.lateralCacheService.getKeySet(this.cacheName);
        }
        catch (IOException ex) {
            this.handleException(ex, "Failed to get key set from " + this.lateralCacheAttributes.getCacheName() + "@" + this.lateralCacheAttributes);
            return Collections.emptySet();
        }
    }

    @Override
    protected boolean processRemove(K key) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removing key:" + key));
        }
        try {
            this.lateralCacheService.remove(this.cacheName, key, CacheInfo.listenerId);
        }
        catch (IOException ex) {
            this.handleException(ex, "Failed to remove " + key + " from " + this.lateralCacheAttributes.getCacheName() + "@" + this.lateralCacheAttributes);
        }
        return false;
    }

    @Override
    protected void processRemoveAll() throws IOException {
        try {
            this.lateralCacheService.removeAll(this.cacheName, CacheInfo.listenerId);
        }
        catch (IOException ex) {
            this.handleException(ex, "Failed to remove all from " + this.lateralCacheAttributes.getCacheName() + "@" + this.lateralCacheAttributes);
        }
    }

    @Override
    protected void processDispose() throws IOException {
        log.debug((Object)"Disposing of lateral cache");
        try {
            this.lateralCacheService.dispose(this.lateralCacheAttributes.getCacheName());
        }
        catch (IOException ex) {
            log.error((Object)"Couldn't dispose", (Throwable)ex);
            this.handleException(ex, "Failed to dispose " + this.lateralCacheAttributes.getCacheName());
        }
    }

    @Override
    public CacheStatus getStatus() {
        return this.lateralCacheService instanceof IZombie ? CacheStatus.ERROR : CacheStatus.ALIVE;
    }

    @Override
    public int getSize() {
        return 0;
    }

    @Override
    public ICacheType.CacheType getCacheType() {
        return ICacheType.CacheType.LATERAL_CACHE;
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    private void handleException(Exception ex, String msg) throws IOException {
        log.error((Object)("Disabling lateral cache due to error " + msg), (Throwable)ex);
        this.lateralCacheService = new ZombieCacheServiceNonLocal(this.lateralCacheAttributes.getZombieQueueMaxSize());
        this.monitor.notifyError();
        if (ex instanceof IOException) {
            throw (IOException)ex;
        }
        throw new IOException(ex.getMessage());
    }

    public void fixCache(ICacheServiceNonLocal<K, V> restoredLateral) {
        if (this.lateralCacheService != null && this.lateralCacheService instanceof ZombieCacheServiceNonLocal) {
            ZombieCacheServiceNonLocal zombie = (ZombieCacheServiceNonLocal)this.lateralCacheService;
            this.lateralCacheService = restoredLateral;
            try {
                zombie.propagateEvents(restoredLateral);
            }
            catch (Exception e) {
                try {
                    this.handleException(e, "Problem propagating events from Zombie Queue to new Lateral Service.");
                }
                catch (IOException e1) {}
            }
        } else {
            this.lateralCacheService = restoredLateral;
        }
    }

    @Override
    public String getStats() {
        return "";
    }

    @Override
    public AuxiliaryCacheAttributes getAuxiliaryCacheAttributes() {
        return this.lateralCacheAttributes;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("\n LateralCache ");
        buf.append("\n Cache Name [" + this.lateralCacheAttributes.getCacheName() + "]");
        buf.append("\n cattr =  [" + this.lateralCacheAttributes + "]");
        return buf.toString();
    }

    @Override
    public String getEventLoggingExtraInfo() {
        return null;
    }

    @Override
    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("LateralCache");
        return stats;
    }
}

