/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine.memory.lru;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.jcs.engine.control.group.GroupAttrName;
import org.apache.commons.jcs.engine.memory.AbstractMemoryCache;
import org.apache.commons.jcs.engine.memory.lru.LRUMemoryCache;
import org.apache.commons.jcs.engine.memory.util.DefaultMemoryElementDescriptor;
import org.apache.commons.jcs.engine.memory.util.MemoryElementDescriptor;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LHMLRUMemoryCache<K, V>
extends AbstractMemoryCache<K, V> {
    private static final Log log = LogFactory.getLog(LRUMemoryCache.class);

    @Override
    public void initialize(CompositeCache<K, V> hub) {
        super.initialize(hub);
        log.info((Object)("initialized LHMLRUMemoryCache for " + this.getCacheName()));
    }

    @Override
    public Map<K, MemoryElementDescriptor<K, V>> createMap() {
        return Collections.synchronizedMap(new LHMSpooler());
    }

    @Override
    public void update(ICacheElement<K, V> ce) throws IOException {
        this.putCnt.incrementAndGet();
        this.map.put(ce.getKey(), new DefaultMemoryElementDescriptor<K, V>(ce));
    }

    @Override
    public ICacheElement<K, V> get(K key) throws IOException {
        MemoryElementDescriptor me;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getting item from cache " + this.getCacheName() + " for key " + key));
        }
        if ((me = (MemoryElementDescriptor)this.map.get(key)) != null) {
            this.hitCnt.incrementAndGet();
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.getCacheName() + ": LHMLRUMemoryCache hit for " + key));
            }
            return me.getCacheElement();
        }
        this.missCnt.incrementAndGet();
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.getCacheName() + ": LHMLRUMemoryCache miss for " + key));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(K key) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removing item for key: " + key));
        }
        boolean removed = false;
        if (key instanceof String && ((String)key).endsWith(":")) {
            Map map = this.map;
            synchronized (map) {
                Iterator itr = this.map.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    Object k = entry.getKey();
                    if (!(k instanceof String) || !((String)k).startsWith(key.toString())) continue;
                    itr.remove();
                    removed = true;
                }
            }
        } else if (key instanceof GroupAttrName && ((GroupAttrName)key).attrName == null) {
            Map map = this.map;
            synchronized (map) {
                Iterator itr = this.map.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    Object k = entry.getKey();
                    if (!(k instanceof GroupAttrName) || !((GroupAttrName)k).groupId.equals(((GroupAttrName)key).groupId)) continue;
                    itr.remove();
                    removed = true;
                }
            }
        } else {
            MemoryElementDescriptor me = (MemoryElementDescriptor)this.map.remove(key);
            if (me != null) {
                removed = true;
            }
        }
        return removed;
    }

    @Override
    public Set<K> getKeySet() {
        return new LinkedHashSet(this.map.keySet());
    }

    @Override
    public IStats getStatistics() {
        IStats stats = super.getStatistics();
        stats.setTypeName("LHMLRU Memory Cache");
        return stats;
    }

    public void dumpCacheEntries() {
        this.dumpMap();
    }

    @Override
    public int freeElements(int numberToFree) throws IOException {
        return 0;
    }

    protected class LHMSpooler
    extends LinkedHashMap<K, MemoryElementDescriptor<K, V>> {
        private static final long serialVersionUID = -1255907868906762484L;

        public LHMSpooler() {
            super((int)((double)LHMLRUMemoryCache.this.getCacheAttributes().getMaxObjects() * 0.5), 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, MemoryElementDescriptor<K, V>> eldest) {
            ICacheElement element = eldest.getValue().getCacheElement();
            if (this.size() <= LHMLRUMemoryCache.this.getCacheAttributes().getMaxObjects()) {
                return false;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("LHMLRU max size: " + LHMLRUMemoryCache.this.getCacheAttributes().getMaxObjects() + ".  Spooling element, key: " + element.getKey()));
            }
            LHMLRUMemoryCache.this.waterfal(element);
            if (log.isDebugEnabled()) {
                log.debug((Object)("LHMLRU size: " + LHMLRUMemoryCache.this.map.size()));
            }
            return true;
        }
    }
}

