/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.access;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import org.apache.commons.jcs.JCS;
import org.apache.commons.jcs.access.CacheAccess;
import org.apache.commons.jcs.access.GroupCacheAccess;
import org.apache.commons.jcs.access.exception.CacheException;
import org.apache.commons.jcs.engine.ElementAttributes;
import org.apache.commons.jcs.engine.behavior.IElementAttributes;
import org.apache.commons.jcs.engine.control.CompositeCacheManager;
import org.apache.commons.jcs.engine.control.event.ElementEventHandlerMockImpl;
import org.apache.commons.jcs.engine.control.event.behavior.IElementEventHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestCacheAccess {
    private static final Log log = LogFactory.getLog(TestCacheAccess.class);
    private CacheAccess<String, String> cache_control = null;
    private GroupCacheAccess<String, String> group_cache_control = null;
    private static boolean isSysOut = false;

    public TestCacheAccess() {
        this("testCache1");
    }

    public TestCacheAccess(String regionName) {
        try {
            this.cache_control = JCS.getInstance((String)regionName);
            this.group_cache_control = JCS.getGroupCacheInstance((String)regionName);
        }
        catch (Exception e) {
            log.error((Object)"Problem getting cache instance", (Throwable)e);
            TestCacheAccess.p(e.toString());
        }
    }

    public void runLoop() {
        try {
            boolean notDone = true;
            String message = null;
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            TestCacheAccess.help();
            while (notDone) {
                int num;
                TestCacheAccess.p("enter command:");
                message = br.readLine();
                if (message == null || message.startsWith("help")) {
                    TestCacheAccess.help();
                    continue;
                }
                if (message.startsWith("gc")) {
                    System.gc();
                    continue;
                }
                if (message.startsWith("getAttributeNames")) {
                    long n_start = System.currentTimeMillis();
                    String groupName = null;
                    StringTokenizer toke = new StringTokenizer(message);
                    int tcnt = 0;
                    while (toke.hasMoreElements()) {
                        String t = (String)toke.nextElement();
                        if (++tcnt != 2) continue;
                        groupName = t.trim();
                    }
                    this.getAttributeNames(groupName);
                    long n_end = System.currentTimeMillis();
                    TestCacheAccess.p("---got attrNames for " + groupName + " in " + String.valueOf(n_end - n_start) + " millis ---");
                    continue;
                }
                if (message.startsWith("shutDown")) {
                    CompositeCacheManager.getInstance().shutDown();
                    notDone = false;
                    return;
                }
                if (message.startsWith("getm")) {
                    this.processGetMultiple(message);
                    continue;
                }
                if (message.startsWith("getg")) {
                    this.processGetGroup(message);
                    continue;
                }
                if (message.startsWith("getag")) {
                    this.processGetAutoGroup(message);
                    continue;
                }
                if (message.startsWith("getMatching")) {
                    this.processGetMatching(message);
                    continue;
                }
                if (message.startsWith("get")) {
                    this.processGet(message);
                    continue;
                }
                if (message.startsWith("putg")) {
                    this.processPutGroup(message);
                    continue;
                }
                if (message.startsWith("putag")) {
                    this.processPutAutoGroup(message);
                    continue;
                }
                if (message.startsWith("putm")) {
                    String numS = message.substring(message.indexOf(" ") + 1, message.length());
                    if (numS == null) {
                        TestCacheAccess.p("usage: putm numbertoput");
                        continue;
                    }
                    num = Integer.parseInt(numS.trim());
                    this.putMultiple(num);
                    continue;
                }
                if (message.startsWith("pute")) {
                    String numS = message.substring(message.indexOf(" ") + 1, message.length());
                    if (numS == null) {
                        TestCacheAccess.p("usage: putme numbertoput");
                        continue;
                    }
                    num = Integer.parseInt(numS.trim());
                    long n_start = System.currentTimeMillis();
                    for (int n = 0; n < num; ++n) {
                        IElementAttributes attrp = this.cache_control.getDefaultElementAttributes();
                        ElementEventHandlerMockImpl hand = new ElementEventHandlerMockImpl();
                        attrp.addElementEventHandler((IElementEventHandler)hand);
                        this.cache_control.put((Object)("key" + n), (Object)("data" + n + " put from ta = junk"), attrp);
                    }
                    long n_end = System.currentTimeMillis();
                    TestCacheAccess.p("---put " + num + " in " + String.valueOf(n_end - n_start) + " millis ---");
                    continue;
                }
                if (message.startsWith("put")) {
                    this.processPut(message);
                    continue;
                }
                if (message.startsWith("removem")) {
                    String numS = message.substring(message.indexOf(" ") + 1, message.length());
                    if (numS == null) {
                        TestCacheAccess.p("usage: removem numbertoremove");
                        continue;
                    }
                    num = Integer.parseInt(numS.trim());
                    this.removeMultiple(num);
                    continue;
                }
                if (message.startsWith("removeall")) {
                    this.cache_control.clear();
                    TestCacheAccess.p("removed all");
                    continue;
                }
                if (message.startsWith("remove")) {
                    String key = message.substring(message.indexOf(" ") + 1, message.length());
                    this.cache_control.remove((Object)key);
                    TestCacheAccess.p("removed " + key);
                    continue;
                }
                if (message.startsWith("deattr")) {
                    IElementAttributes ae = this.cache_control.getDefaultElementAttributes();
                    TestCacheAccess.p("Default IElementAttributes " + ae);
                    continue;
                }
                if (message.startsWith("cloneattr")) {
                    String numS = message.substring(message.indexOf(" ") + 1, message.length());
                    if (numS == null) {
                        TestCacheAccess.p("usage: put numbertoput");
                        continue;
                    }
                    num = Integer.parseInt(numS.trim());
                    ElementAttributes attrp = new ElementAttributes();
                    long n_start = System.currentTimeMillis();
                    for (int n = 0; n < num; ++n) {
                        attrp.clone();
                    }
                    long n_end = System.currentTimeMillis();
                    TestCacheAccess.p("---cloned attr " + num + " in " + String.valueOf(n_end - n_start) + " millis ---");
                    continue;
                }
                if (message.startsWith("switch")) {
                    String name = message.substring(message.indexOf(" ") + 1, message.length());
                    this.setRegion(name);
                    TestCacheAccess.p("switched to cache = " + name);
                    TestCacheAccess.p(this.cache_control.toString());
                    continue;
                }
                if (message.startsWith("stats")) {
                    TestCacheAccess.p(this.cache_control.getStats());
                    continue;
                }
                if (message.startsWith("gc")) {
                    System.gc();
                    TestCacheAccess.p("Called system.gc()");
                    continue;
                }
                if (!message.startsWith("random")) continue;
                this.processRandom(message);
            }
        }
        catch (CacheException e) {
            TestCacheAccess.p(e.toString());
            e.printStackTrace(System.out);
        }
        catch (IOException e) {
            TestCacheAccess.p(e.toString());
            e.printStackTrace(System.out);
        }
    }

    private void processGetMultiple(String message) {
        int num = 0;
        boolean show = true;
        StringTokenizer toke = new StringTokenizer(message);
        int tcnt = 0;
        while (toke.hasMoreElements()) {
            String t = (String)toke.nextElement();
            if (++tcnt == 2) {
                try {
                    num = Integer.parseInt(t.trim());
                }
                catch (NumberFormatException nfe) {
                    TestCacheAccess.p(t + "not a number");
                }
                continue;
            }
            if (tcnt != 3) continue;
            show = Boolean.valueOf(t);
        }
        if (tcnt < 2) {
            TestCacheAccess.p("usage: get numbertoget show values[true|false]");
        } else {
            this.getMultiple(num, show);
        }
    }

    private void processGetGroup(String message) {
        String key = null;
        String group = null;
        boolean show = true;
        StringTokenizer toke = new StringTokenizer(message);
        int tcnt = 0;
        while (toke.hasMoreElements()) {
            String t = (String)toke.nextElement();
            if (++tcnt == 2) {
                key = t.trim();
                continue;
            }
            if (tcnt == 3) {
                group = t.trim();
                continue;
            }
            if (tcnt != 4) continue;
            show = Boolean.valueOf(t);
        }
        if (tcnt < 2) {
            TestCacheAccess.p("usage: get key show values[true|false]");
        } else {
            long n_start = System.currentTimeMillis();
            try {
                Object obj = this.group_cache_control.getFromGroup((Object)key, group);
                if (show && obj != null) {
                    TestCacheAccess.p(obj.toString());
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            long n_end = System.currentTimeMillis();
            TestCacheAccess.p("---got " + key + " from group " + group + " in " + String.valueOf(n_end - n_start) + " millis ---");
        }
    }

    private void processGetAutoGroup(String message) {
        int num = 0;
        String group = null;
        boolean show = true;
        StringTokenizer toke = new StringTokenizer(message);
        int tcnt = 0;
        while (toke.hasMoreElements()) {
            String t = (String)toke.nextElement();
            if (++tcnt == 2) {
                num = Integer.parseInt(t.trim());
                continue;
            }
            if (tcnt == 3) {
                group = t.trim();
                continue;
            }
            if (tcnt != 4) continue;
            show = Boolean.valueOf(t);
        }
        if (tcnt < 2) {
            TestCacheAccess.p("usage: get key show values[true|false]");
        } else {
            long n_start = System.currentTimeMillis();
            try {
                for (int a = 0; a < num; ++a) {
                    Object obj = this.group_cache_control.getFromGroup((Object)("keygr" + a), group);
                    if (!show || obj == null) continue;
                    TestCacheAccess.p(obj.toString());
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            long n_end = System.currentTimeMillis();
            TestCacheAccess.p("---got " + num + " from group " + group + " in " + String.valueOf(n_end - n_start) + " millis ---");
        }
    }

    private void processPutGroup(String message) throws CacheException {
        String group = null;
        String key = null;
        StringTokenizer toke = new StringTokenizer(message);
        int tcnt = 0;
        while (toke.hasMoreElements()) {
            String t = (String)toke.nextElement();
            if (++tcnt == 2) {
                key = t.trim();
                continue;
            }
            if (tcnt != 3) continue;
            group = t.trim();
        }
        if (tcnt < 3) {
            TestCacheAccess.p("usage: putg key group");
        } else {
            long n_start = System.currentTimeMillis();
            this.group_cache_control.putInGroup((Object)key, group, (Object)("data from putg ----asdfasfas-asfasfas-asfas in group " + group));
            long n_end = System.currentTimeMillis();
            TestCacheAccess.p("---put " + key + " in group " + group + " in " + String.valueOf(n_end - n_start) + " millis ---");
        }
    }

    private void processPutAutoGroup(String message) throws CacheException {
        String group = null;
        int num = 0;
        StringTokenizer toke = new StringTokenizer(message);
        int tcnt = 0;
        while (toke.hasMoreElements()) {
            String t = (String)toke.nextElement();
            if (++tcnt == 2) {
                num = Integer.parseInt(t.trim());
                continue;
            }
            if (tcnt != 3) continue;
            group = t.trim();
        }
        if (tcnt < 3) {
            TestCacheAccess.p("usage: putag num group");
        } else {
            long n_start = System.currentTimeMillis();
            for (int a = 0; a < num; ++a) {
                this.group_cache_control.putInGroup((Object)("keygr" + a), group, (Object)("data " + a + " from putag ----asdfasfas-asfasfas-asfas in group " + group));
            }
            long n_end = System.currentTimeMillis();
            TestCacheAccess.p("---put " + num + " in group " + group + " in " + String.valueOf(n_end - n_start) + " millis ---");
        }
    }

    private void processPut(String message) throws CacheException {
        String key = null;
        String val = null;
        StringTokenizer toke = new StringTokenizer(message);
        int tcnt = 0;
        while (toke.hasMoreElements()) {
            String t = (String)toke.nextElement();
            if (++tcnt == 2) {
                key = t.trim();
                continue;
            }
            if (tcnt != 3) continue;
            val = t.trim();
        }
        if (tcnt < 3) {
            TestCacheAccess.p("usage: put key val");
        } else {
            long n_start = System.currentTimeMillis();
            this.cache_control.put(key, val);
            long n_end = System.currentTimeMillis();
            TestCacheAccess.p("---put " + key + " | " + val + " in " + String.valueOf(n_end - n_start) + " millis ---");
        }
    }

    private void processRandom(String message) {
        String rangeS = "";
        String numOpsS = "";
        boolean show = true;
        StringTokenizer toke = new StringTokenizer(message);
        int tcnt = 0;
        while (toke.hasMoreElements()) {
            String t = (String)toke.nextElement();
            if (++tcnt == 2) {
                rangeS = t.trim();
                continue;
            }
            if (tcnt == 3) {
                numOpsS = t.trim();
                continue;
            }
            if (tcnt != 4) continue;
            show = Boolean.valueOf(t);
        }
        String numS = message.substring(message.indexOf(" ") + 1, message.length());
        int range = 0;
        int numOps = 0;
        try {
            range = Integer.parseInt(rangeS.trim());
            numOps = Integer.parseInt(numOpsS.trim());
        }
        catch (Exception e) {
            TestCacheAccess.p("usage: random range numOps show");
            TestCacheAccess.p("ex.  random 100 1000 false");
        }
        if (numS == null) {
            TestCacheAccess.p("usage: random range numOps show");
            TestCacheAccess.p("ex.  random 100 1000 false");
        } else {
            this.random(range, numOps, show);
        }
    }

    private void processGet(String message) {
        String key = null;
        boolean show = true;
        StringTokenizer toke = new StringTokenizer(message);
        int tcnt = 0;
        while (toke.hasMoreElements()) {
            String t = (String)toke.nextElement();
            if (++tcnt == 2) {
                key = t.trim();
                continue;
            }
            if (tcnt != 3) continue;
            show = Boolean.valueOf(t);
        }
        if (tcnt < 2) {
            TestCacheAccess.p("usage: get key show values[true|false]");
        } else {
            long n_start = System.currentTimeMillis();
            try {
                Object obj = this.cache_control.get(key);
                if (show && obj != null) {
                    TestCacheAccess.p(obj.toString());
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            long n_end = System.currentTimeMillis();
            TestCacheAccess.p("---got " + key + " in " + String.valueOf(n_end - n_start) + " millis ---");
        }
    }

    private void processGetMatching(String message) {
        String pattern = null;
        boolean show = true;
        StringTokenizer toke = new StringTokenizer(message);
        int tcnt = 0;
        while (toke.hasMoreElements()) {
            String t = (String)toke.nextElement();
            if (++tcnt == 2) {
                pattern = t.trim();
                continue;
            }
            if (tcnt != 3) continue;
            show = Boolean.valueOf(t);
        }
        if (tcnt < 2) {
            TestCacheAccess.p("usage: getMatching key show values[true|false]");
        } else {
            long n_start = System.currentTimeMillis();
            try {
                Map results = this.cache_control.getMatching(pattern);
                if (show && results != null) {
                    TestCacheAccess.p(results.toString());
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            long n_end = System.currentTimeMillis();
            TestCacheAccess.p("---gotMatching [" + pattern + "] in " + String.valueOf(n_end - n_start) + " millis ---");
        }
    }

    public static void main(String[] args) {
        isSysOut = true;
        String ccfFileName = args[0];
        if (ccfFileName != null) {
            JCS.setConfigFilename((String)ccfFileName);
        }
        TestCacheAccess tca = new TestCacheAccess("testCache1");
        tca.runLoop();
    }

    public void getMultiple(int num) {
        this.getMultiple(num, false);
    }

    public void getMultiple(int num, boolean show) {
        long n_start = System.currentTimeMillis();
        for (int n = 0; n < num; ++n) {
            try {
                Object obj = this.cache_control.get((Object)("key" + n));
                if (!show || obj == null) continue;
                TestCacheAccess.p(obj.toString());
                continue;
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        long n_end = System.currentTimeMillis();
        TestCacheAccess.p("---got " + num + " in " + String.valueOf(n_end - n_start) + " millis ---");
    }

    public void putMultiple(int num) {
        try {
            long n_start = System.currentTimeMillis();
            for (int n = 0; n < num; ++n) {
                this.cache_control.put((Object)("key" + n), (Object)("data" + n + " put from ta = junk"));
            }
            long n_end = System.currentTimeMillis();
            TestCacheAccess.p("---put " + num + " in " + String.valueOf(n_end - n_start) + " millis ---");
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public void removeMultiple(int num) {
        try {
            long n_start = System.currentTimeMillis();
            for (int n = 0; n < num; ++n) {
                this.cache_control.remove((Object)("key" + n));
            }
            long n_end = System.currentTimeMillis();
            TestCacheAccess.p("---removed " + num + " in " + String.valueOf(n_end - n_start) + " millis ---");
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public void random(int range, int numOps) {
        this.random(range, numOps, false);
    }

    public void random(int range, int numOps, boolean show) {
        try {
            for (int i = 1; i < numOps; ++i) {
                Random ran = new Random(i);
                int n = ran.nextInt(4);
                int kn = ran.nextInt(range);
                String key = "key" + kn;
                if (n == 1) {
                    this.cache_control.put((Object)key, (Object)("data" + i + " junk asdfffffffadfasdfasf " + kn + ":" + n));
                    if (show) {
                        TestCacheAccess.p("put " + key);
                    }
                } else if (n == 2) {
                    this.cache_control.remove((Object)key);
                    if (show) {
                        TestCacheAccess.p("removed " + key);
                    }
                } else {
                    Object obj = this.cache_control.get((Object)key);
                    if (show && obj != null) {
                        TestCacheAccess.p(obj.toString());
                    }
                }
                if (i % 10000 != 0) continue;
                TestCacheAccess.p(this.cache_control.getStats());
            }
            TestCacheAccess.p("Finished random cycle of " + numOps);
        }
        catch (Exception e) {
            TestCacheAccess.p(e.toString());
            e.printStackTrace(System.out);
        }
    }

    public void setRegion(String name) {
        try {
            this.cache_control = JCS.getInstance((String)name);
        }
        catch (Exception e) {
            TestCacheAccess.p(e.toString());
            e.printStackTrace(System.out);
        }
    }

    public static void p(String s) {
        if (isSysOut) {
            System.out.println(s);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)s);
        }
    }

    public static void help() {
        TestCacheAccess.p("\n\n\n\n");
        TestCacheAccess.p("type 'shutDown' to shutdown the cache");
        TestCacheAccess.p("type 'getm num show[false|true]' to get num automatically from a region");
        TestCacheAccess.p("type 'putm num' to put num automatically to a region");
        TestCacheAccess.p("type 'removeall' to remove all items in a region");
        TestCacheAccess.p("type 'remove key' to remove");
        TestCacheAccess.p("type 'removem num' to remove a number automatically");
        TestCacheAccess.p("type 'getMatching pattern show' to getMatching");
        TestCacheAccess.p("type 'get key show' to get");
        TestCacheAccess.p("type 'getg key group show' to get");
        TestCacheAccess.p("type 'getag num group show' to get automatically from a group");
        TestCacheAccess.p("type 'getAttributeNames group' to get a list og the group elements");
        TestCacheAccess.p("type 'putg key group val' to put");
        TestCacheAccess.p("type 'putag num group' to put automatically from a group");
        TestCacheAccess.p("type 'put key val' to put");
        TestCacheAccess.p("type 'stats' to get stats");
        TestCacheAccess.p("type 'deattr' to get the default element attributes");
        TestCacheAccess.p("type 'cloneattr num' to clone attr");
        TestCacheAccess.p("type 'random range numOps' to put, get, and remove randomly");
        TestCacheAccess.p("type 'switch name' to switch to this region name");
        TestCacheAccess.p("type 'gc' to call System.gc()");
        TestCacheAccess.p("type 'help' for commands");
    }

    public void getAttributeNames(String groupName) {
        Iterator iter = this.group_cache_control.getGroupKeys(groupName).iterator();
        while (iter.hasNext()) {
            TestCacheAccess.p("=" + (String)iter.next());
        }
    }
}

