/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine.control;

import java.io.IOException;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.jcs.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs.auxiliary.MockAuxiliaryCache;
import org.apache.commons.jcs.engine.CacheElement;
import org.apache.commons.jcs.engine.CompositeCacheAttributes;
import org.apache.commons.jcs.engine.ElementAttributes;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICacheType;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs.engine.behavior.IElementAttributes;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.jcs.engine.memory.MockMemoryCache;

public class CompositeCacheUnitTest
extends TestCase {
    public void testShutdownMemoryFlush() throws IOException {
        String cacheName = "testCacheName";
        String mockMemoryCacheClassName = "org.apache.commons.jcs.engine.memory.MockMemoryCache";
        CompositeCacheAttributes cattr = new CompositeCacheAttributes();
        cattr.setMemoryCacheName(mockMemoryCacheClassName);
        ElementAttributes attr = new ElementAttributes();
        CompositeCache cache = new CompositeCache((ICompositeCacheAttributes)cattr, (IElementAttributes)attr);
        MockAuxiliaryCache diskMock = new MockAuxiliaryCache();
        diskMock.cacheType = ICacheType.CacheType.DISK_CACHE;
        AuxiliaryCache[] aux = new AuxiliaryCache[]{diskMock};
        cache.setAuxCaches(aux);
        int numToInsert = 10;
        for (int i = 0; i < numToInsert; ++i) {
            CacheElement element = new CacheElement(cacheName, (Object)String.valueOf(i), (Object)i);
            cache.update((ICacheElement)element, false);
        }
        cache.dispose();
        MockMemoryCache memoryCache = (MockMemoryCache)cache.getMemoryCache();
        CompositeCacheUnitTest.assertEquals((String)"Wrong number freed.", (int)numToInsert, (int)memoryCache.lastNumberOfFreedElements);
    }

    public void testShutdownMemoryFlush_noDisk() throws IOException {
        String cacheName = "testCacheName";
        String mockMemoryCacheClassName = "org.apache.commons.jcs.engine.memory.MockMemoryCache";
        CompositeCacheAttributes cattr = new CompositeCacheAttributes();
        cattr.setMemoryCacheName(mockMemoryCacheClassName);
        ElementAttributes attr = new ElementAttributes();
        CompositeCache cache = new CompositeCache((ICompositeCacheAttributes)cattr, (IElementAttributes)attr);
        MockAuxiliaryCache diskMock = new MockAuxiliaryCache();
        diskMock.cacheType = ICacheType.CacheType.REMOTE_CACHE;
        AuxiliaryCache[] aux = new AuxiliaryCache[]{diskMock};
        cache.setAuxCaches(aux);
        int numToInsert = 10;
        for (int i = 0; i < numToInsert; ++i) {
            CacheElement element = new CacheElement(cacheName, (Object)String.valueOf(i), (Object)i);
            cache.update((ICacheElement)element, false);
        }
        cache.dispose();
        MockMemoryCache memoryCache = (MockMemoryCache)cache.getMemoryCache();
        CompositeCacheUnitTest.assertEquals((String)"Wrong number freed.", (int)0, (int)memoryCache.lastNumberOfFreedElements);
    }

    public void testGetMatching_Normal() throws IOException {
        int maxMemorySize = 1000;
        String keyprefix1 = "MyPrefix1";
        String keyprefix2 = "MyPrefix2";
        String cacheName = "testGetMatching_Normal";
        String memoryCacheClassName = "org.apache.commons.jcs.engine.memory.lru.LRUMemoryCache";
        CompositeCacheAttributes cattr = new CompositeCacheAttributes();
        cattr.setMemoryCacheName(memoryCacheClassName);
        cattr.setMaxObjects(maxMemorySize);
        ElementAttributes attr = new ElementAttributes();
        CompositeCache cache = new CompositeCache((ICompositeCacheAttributes)cattr, (IElementAttributes)attr);
        MockAuxiliaryCache diskMock = new MockAuxiliaryCache();
        diskMock.cacheType = ICacheType.CacheType.DISK_CACHE;
        AuxiliaryCache[] aux = new AuxiliaryCache[]{diskMock};
        cache.setAuxCaches(aux);
        int numToInsertPrefix1 = 10;
        for (int i = 0; i < numToInsertPrefix1; ++i) {
            CacheElement element = new CacheElement(cacheName, (Object)(keyprefix1 + String.valueOf(i)), (Object)i);
            cache.update((ICacheElement)element, false);
        }
        int numToInsertPrefix2 = 50;
        for (int i = 0; i < numToInsertPrefix2; ++i) {
            CacheElement element = new CacheElement(cacheName, (Object)(keyprefix2 + String.valueOf(i)), (Object)i);
            cache.update((ICacheElement)element, false);
        }
        Map result1 = cache.getMatching(keyprefix1 + "\\S+");
        Map result2 = cache.getMatching(keyprefix2 + "\\S+");
        CompositeCacheUnitTest.assertEquals((String)"Wrong number returned 1:", (int)numToInsertPrefix1, (int)result1.size());
        CompositeCacheUnitTest.assertEquals((String)"Wrong number returned 2:", (int)numToInsertPrefix2, (int)result2.size());
    }

    public void testGetMatching_NotOnDisk() throws IOException {
        int maxMemorySize = 0;
        String cacheName = "testGetMatching_NotOnDisk";
        String memoryCacheClassName = "org.apache.commons.jcs.engine.memory.lru.LRUMemoryCache";
        CompositeCacheAttributes cattr = new CompositeCacheAttributes();
        cattr.setCacheName(cacheName);
        cattr.setMemoryCacheName(memoryCacheClassName);
        cattr.setMaxObjects(maxMemorySize);
        ElementAttributes attr = new ElementAttributes();
        CompositeCache cache = new CompositeCache((ICompositeCacheAttributes)cattr, (IElementAttributes)attr);
        MockAuxiliaryCache diskMock = new MockAuxiliaryCache();
        diskMock.cacheType = ICacheType.CacheType.DISK_CACHE;
        AuxiliaryCache[] aux = new AuxiliaryCache[]{diskMock};
        cache.setAuxCaches(aux);
        cache.getMatching("junk");
        CompositeCacheUnitTest.assertEquals((String)"Wrong number of calls", (int)1, (int)diskMock.getMatchingCallCount);
    }

    public void testGetMatching_NotOnRemote() throws IOException {
        int maxMemorySize = 0;
        String cacheName = "testGetMatching_NotOnDisk";
        String memoryCacheClassName = "org.apache.commons.jcs.engine.memory.lru.LRUMemoryCache";
        CompositeCacheAttributes cattr = new CompositeCacheAttributes();
        cattr.setCacheName(cacheName);
        cattr.setMemoryCacheName(memoryCacheClassName);
        cattr.setMaxObjects(maxMemorySize);
        ElementAttributes attr = new ElementAttributes();
        CompositeCache cache = new CompositeCache((ICompositeCacheAttributes)cattr, (IElementAttributes)attr);
        MockAuxiliaryCache diskMock = new MockAuxiliaryCache();
        diskMock.cacheType = ICacheType.CacheType.REMOTE_CACHE;
        AuxiliaryCache[] aux = new AuxiliaryCache[]{diskMock};
        cache.setAuxCaches(aux);
        cache.getMatching("junk");
        CompositeCacheUnitTest.assertEquals((String)"Wrong number of calls", (int)1, (int)diskMock.getMatchingCallCount);
    }
}

