/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine.memory.mru;

import junit.framework.TestCase;
import org.apache.commons.jcs.JCS;
import org.apache.commons.jcs.access.CacheAccess;
import org.apache.commons.jcs.engine.memory.lru.LRUMemoryCache;
import org.apache.commons.jcs.engine.memory.mru.MRUMemoryCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LRUvsMRUPerformanceTest
extends TestCase {
    float ratioPut = 0.0f;
    float ratioGet = 0.0f;
    float target = 1.2f;
    int loops = 20;
    int tries = 10000;

    public void testSimpleLoad() throws Exception {
        Log log1 = LogFactory.getLog(LRUMemoryCache.class);
        if (log1.isDebugEnabled()) {
            System.out.println("The log level must be at info or above for the a performance test.");
            return;
        }
        Log log2 = LogFactory.getLog(MRUMemoryCache.class);
        if (log2.isDebugEnabled()) {
            System.out.println("The log level must be at info or above for the a performance test.");
            return;
        }
        this.doWork();
    }

    public void doWork() {
        long start = 0L;
        long end = 0L;
        long time = 0L;
        float tPer = 0.0f;
        long putTotalLRU = 0L;
        long getTotalLRU = 0L;
        long putTotalMRU = 0L;
        long getTotalMRU = 0L;
        try {
            JCS.setConfigFilename((String)"/TestMRUCache.ccf");
            CacheAccess cache = JCS.getInstance((String)"lruDefined");
            CacheAccess mru = JCS.getInstance((String)"mruDefined");
            System.out.println("LRU = " + cache);
            for (int j = 0; j < this.loops; ++j) {
                int i;
                System.out.println("Beginning loop " + j);
                String name = "LRU      ";
                start = System.currentTimeMillis();
                for (i = 0; i < this.tries; ++i) {
                    cache.put((Object)("key:" + i), (Object)("data" + i));
                }
                end = System.currentTimeMillis();
                time = end - start;
                putTotalLRU += time;
                tPer = Float.intBitsToFloat((int)time) / Float.intBitsToFloat(this.tries);
                System.out.println(name + " put time for " + this.tries + " = " + time + "; millis per = " + tPer);
                start = System.currentTimeMillis();
                for (i = 0; i < this.tries; ++i) {
                    cache.get((Object)("key:" + i));
                }
                end = System.currentTimeMillis();
                time = end - start;
                getTotalLRU += time;
                tPer = Float.intBitsToFloat((int)time) / Float.intBitsToFloat(this.tries);
                System.out.println(name + " get time for " + this.tries + " = " + time + "; millis per = " + tPer);
                name = "MRU";
                start = System.currentTimeMillis();
                for (i = 0; i < this.tries; ++i) {
                    mru.put((Object)("key:" + i), (Object)("data" + i));
                }
                end = System.currentTimeMillis();
                time = end - start;
                putTotalMRU += time;
                tPer = Float.intBitsToFloat((int)time) / Float.intBitsToFloat(this.tries);
                System.out.println(name + " put time for " + this.tries + " = " + time + "; millis per = " + tPer);
                start = System.currentTimeMillis();
                for (i = 0; i < this.tries; ++i) {
                    mru.get((Object)("key:" + i));
                }
                end = System.currentTimeMillis();
                time = end - start;
                getTotalMRU += time;
                tPer = Float.intBitsToFloat((int)time) / Float.intBitsToFloat(this.tries);
                System.out.println(name + " get time for " + this.tries + " = " + time + "; millis per = " + tPer);
                System.out.println("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            System.out.println(e);
        }
        long putAvJCS = putTotalLRU / (long)this.loops;
        long getAvJCS = getTotalLRU / (long)this.loops;
        long putAvHashtable = putTotalMRU / (long)this.loops;
        long getAvHashtable = getTotalMRU / (long)this.loops;
        System.out.println("Finished " + this.loops + " loops of " + this.tries + " gets and puts");
        System.out.println("\n");
        System.out.println("Put average for JCS       = " + putAvJCS);
        System.out.println("Put average for MRU = " + putAvHashtable);
        this.ratioPut = Float.intBitsToFloat((int)putAvJCS) / Float.intBitsToFloat((int)putAvHashtable);
        System.out.println("JCS puts took " + this.ratioPut + " times the Hashtable, the goal is <" + this.target + "x");
        System.out.println("\n");
        System.out.println("Get average for JCS       = " + getAvJCS);
        System.out.println("Get average for MRU = " + getAvHashtable);
        this.ratioGet = Float.intBitsToFloat((int)getAvJCS) / Float.intBitsToFloat((int)getAvHashtable);
        System.out.println("JCS gets took " + this.ratioGet + " times the Hashtable, the goal is <" + this.target + "x");
    }
}

