/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.jcache;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.expiry.AccessedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriter;
import javax.cache.spi.CachingProvider;
import org.junit.Assert;
import org.junit.Test;

public class CacheTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void accessExpiry() throws InterruptedException {
        CachingProvider cachingProvider = Caching.getCachingProvider();
        CacheManager cacheManager = cachingProvider.getCacheManager(cachingProvider.getDefaultURI(), Thread.currentThread().getContextClassLoader(), cachingProvider.getDefaultProperties());
        Cache cache = cacheManager.createCache("test", (Configuration)new MutableConfiguration().setStoreByValue(false).setStatisticsEnabled(true).setManagementEnabled(true).setTypes(Integer.class, Integer.class).setExpiryPolicyFactory(AccessedExpiryPolicy.factoryOf((Duration)new Duration(TimeUnit.MILLISECONDS, 500L))));
        try {
            cache.put((Object)1, (Object)2);
            cache.get((Object)1);
            Thread.sleep(650L);
            Assert.assertFalse((boolean)cache.containsKey((Object)1));
            cache.put((Object)1, (Object)2);
            for (int i = 0; i < 3; ++i) {
                Thread.sleep(250L);
                Assert.assertTrue((String)("iteration: " + Integer.toString(i)), (boolean)cache.containsKey((Object)1));
            }
            Assert.assertTrue((boolean)cache.containsKey((Object)1));
            Thread.sleep(650L);
            Assert.assertFalse((boolean)cache.containsKey((Object)1));
        }
        finally {
            cacheManager.close();
            cachingProvider.close();
        }
    }

    @Test
    public void getPut() {
        CachingProvider cachingProvider = Caching.getCachingProvider();
        CacheManager cacheManager = cachingProvider.getCacheManager();
        Cache cache = cacheManager.createCache("default", (Configuration)new MutableConfiguration());
        Assert.assertFalse((boolean)cache.containsKey((Object)"foo"));
        cache.put((Object)"foo", (Object)"bar");
        Assert.assertTrue((boolean)cache.containsKey((Object)"foo"));
        Assert.assertEquals((Object)"bar", (Object)cache.get((Object)"foo"));
        cache.remove((Object)"foo");
        Assert.assertFalse((boolean)cache.containsKey((Object)"foo"));
        cachingProvider.close();
    }

    @Test
    public void listeners() {
        CachingProvider cachingProvider = Caching.getCachingProvider();
        CacheManager cacheManager = cachingProvider.getCacheManager();
        cacheManager.createCache("default", (Configuration)new MutableConfiguration());
        Cache cache = cacheManager.getCache("default");
        final HashSet event = new HashSet();
        cache.registerCacheEntryListener((CacheEntryListenerConfiguration)new CacheEntryListenerConfiguration<String, String>(){

            public Factory<CacheEntryListener<? super String, ? super String>> getCacheEntryListenerFactory() {
                return new Factory<CacheEntryListener<? super String, ? super String>>(){

                    public CacheEntryListener<? super String, ? super String> create() {
                        return new CacheEntryCreatedListener<String, String>(){

                            public void onCreated(Iterable<CacheEntryEvent<? extends String, ? extends String>> cacheEntryEvents) throws CacheEntryListenerException {
                                event.add(cacheEntryEvents.iterator().next().getKey());
                            }
                        };
                    }
                };
            }

            public boolean isOldValueRequired() {
                return false;
            }

            public Factory<CacheEntryEventFilter<? super String, ? super String>> getCacheEntryEventFilterFactory() {
                return null;
            }

            public boolean isSynchronous() {
                return false;
            }
        });
        cache.registerCacheEntryListener((CacheEntryListenerConfiguration)new CacheEntryListenerConfiguration<String, String>(){

            public Factory<CacheEntryListener<? super String, ? super String>> getCacheEntryListenerFactory() {
                return new Factory<CacheEntryListener<? super String, ? super String>>(){

                    public CacheEntryListener<? super String, ? super String> create() {
                        return new CacheEntryUpdatedListener<String, String>(){

                            public void onUpdated(Iterable<CacheEntryEvent<? extends String, ? extends String>> cacheEntryEvents) throws CacheEntryListenerException {
                                event.add(cacheEntryEvents.iterator().next().getKey());
                            }
                        };
                    }
                };
            }

            public boolean isOldValueRequired() {
                return false;
            }

            public Factory<CacheEntryEventFilter<? super String, ? super String>> getCacheEntryEventFilterFactory() {
                return null;
            }

            public boolean isSynchronous() {
                return false;
            }
        });
        cache.registerCacheEntryListener((CacheEntryListenerConfiguration)new CacheEntryListenerConfiguration<String, String>(){

            public Factory<CacheEntryListener<? super String, ? super String>> getCacheEntryListenerFactory() {
                return new Factory<CacheEntryListener<? super String, ? super String>>(){

                    public CacheEntryListener<? super String, ? super String> create() {
                        return new CacheEntryRemovedListener<String, String>(){

                            public void onRemoved(Iterable<CacheEntryEvent<? extends String, ? extends String>> cacheEntryEvents) throws CacheEntryListenerException {
                                event.add(cacheEntryEvents.iterator().next().getKey());
                            }
                        };
                    }
                };
            }

            public boolean isOldValueRequired() {
                return false;
            }

            public Factory<CacheEntryEventFilter<? super String, ? super String>> getCacheEntryEventFilterFactory() {
                return null;
            }

            public boolean isSynchronous() {
                return false;
            }
        });
        cache.put((Object)"foo", (Object)"bar");
        Assert.assertEquals((long)1L, (long)event.size());
        Assert.assertEquals((Object)"foo", event.iterator().next());
        event.clear();
        cache.put((Object)"foo", (Object)"new");
        Assert.assertEquals((long)1L, (long)event.size());
        Assert.assertEquals((Object)"foo", event.iterator().next());
        event.clear();
        cache.remove((Object)"foo");
        Assert.assertEquals((long)1L, (long)event.size());
        Assert.assertEquals((Object)"foo", event.iterator().next());
        cachingProvider.close();
    }

    @Test
    public void loader() {
        CachingProvider cachingProvider = Caching.getCachingProvider();
        CacheManager cacheManager = cachingProvider.getCacheManager();
        cacheManager.createCache("default", (Configuration)new CompleteConfiguration<Object, Object>(){

            public boolean isReadThrough() {
                return true;
            }

            public boolean isWriteThrough() {
                return false;
            }

            public boolean isStatisticsEnabled() {
                return false;
            }

            public boolean isManagementEnabled() {
                return false;
            }

            public Iterable<CacheEntryListenerConfiguration<Object, Object>> getCacheEntryListenerConfigurations() {
                return null;
            }

            public Factory<CacheLoader<Object, Object>> getCacheLoaderFactory() {
                return new Factory<CacheLoader<Object, Object>>(){

                    public CacheLoader<Object, Object> create() {
                        return new CacheLoader<Object, Object>(){

                            public Object load(Object key) throws CacheLoaderException {
                                return "super";
                            }

                            public Map<Object, Object> loadAll(Iterable<?> keys) throws CacheLoaderException {
                                return null;
                            }
                        };
                    }
                };
            }

            public Factory<CacheWriter<? super Object, ? super Object>> getCacheWriterFactory() {
                return null;
            }

            public Factory<ExpiryPolicy> getExpiryPolicyFactory() {
                return null;
            }

            public Class<Object> getKeyType() {
                return Object.class;
            }

            public Class<Object> getValueType() {
                return Object.class;
            }

            public boolean isStoreByValue() {
                return false;
            }
        });
        Cache cache = cacheManager.getCache("default");
        Assert.assertEquals((Object)"super", (Object)cache.get((Object)"lazilyLoaded"));
        cachingProvider.close();
    }
}

