/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs;

import junit.extensions.ActiveTestSuite;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.commons.jcs.JCS;
import org.apache.commons.jcs.access.CacheAccess;

public class TestTCPLateralCache
extends TestCase {
    private static int items = 200;

    public TestTCPLateralCache(String testName) {
        super(testName);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{TestTCPLateralCache.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    public static Test suite() {
        ActiveTestSuite suite = new ActiveTestSuite();
        suite.addTest((Test)new TestTCPLateralCache("testTcpRegion1_no_receiver"){

            public void runTest() throws Exception {
                this.runTestForRegion("testTcpRegion1");
            }
        });
        return suite;
    }

    public void setUp() {
        JCS.setConfigFilename((String)"/TestTCPLateralCache.ccf");
    }

    public void runTestForRegion(String region) throws Exception {
        int i;
        CacheAccess jcs = JCS.getInstance((String)region);
        for (i = 0; i <= items; ++i) {
            jcs.put((Object)(i + ":key"), (Object)(region + " data " + i));
        }
        for (i = 0; i <= items; ++i) {
            String value = (String)jcs.get((Object)(i + ":key"));
            TestTCPLateralCache.assertEquals((String)(region + " data " + i), (String)value);
        }
        for (i = 0; i <= items; ++i) {
            jcs.remove((Object)(i + ":key"));
        }
        for (i = 0; i <= items; ++i) {
            TestTCPLateralCache.assertNull((String)("Removed key should be null: " + i + ":key"), (Object)jcs.get((Object)(i + ":key")));
        }
    }
}

