/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.access;

import java.util.Set;
import junit.framework.TestCase;
import org.apache.commons.jcs.JCS;
import org.apache.commons.jcs.access.GroupCacheAccess;
import org.apache.commons.jcs.access.exception.CacheException;

public class GroupCacheAccessUnitTest
extends TestCase {
    public void testPutAndGet() throws Exception {
        GroupCacheAccess access = JCS.getGroupCacheInstance((String)"test");
        GroupCacheAccessUnitTest.assertNotNull((String)"We should have an access class", (Object)access);
        String key = "mykey";
        String group = "mygroup";
        String value = "myvalue";
        access.putInGroup((Object)key, group, (Object)value);
        String returnedValue1 = (String)access.getFromGroup((Object)key, group);
        GroupCacheAccessUnitTest.assertEquals((String)"Wrong value returned.", (String)value, (String)returnedValue1);
    }

    public void testPutNullKey() throws Exception {
        GroupCacheAccess access = JCS.getGroupCacheInstance((String)"test");
        GroupCacheAccessUnitTest.assertNotNull((String)"We should have an access class", (Object)access);
        Object key = null;
        String group = "mygroup";
        String value = "myvalue";
        try {
            access.putInGroup(key, group, (Object)value);
            GroupCacheAccessUnitTest.fail((String)"Should not have been able to put a null key.");
        }
        catch (CacheException e) {
            GroupCacheAccessUnitTest.assertTrue((String)"Should have the word null in the error message.", (e.getMessage().indexOf("null") != -1 ? 1 : 0) != 0);
        }
    }

    public void testPutNullValue() throws Exception {
        GroupCacheAccess access = JCS.getGroupCacheInstance((String)"test");
        GroupCacheAccessUnitTest.assertNotNull((String)"We should have an access class", (Object)access);
        String key = "myKey";
        String group = "mygroup";
        Object value = null;
        try {
            access.putInGroup((Object)key, group, value);
            GroupCacheAccessUnitTest.fail((String)"Should not have been able to put a null object.");
        }
        catch (CacheException e) {
            GroupCacheAccessUnitTest.assertTrue((String)"Should have the word null in the error message.", (e.getMessage().indexOf("null") != -1 ? 1 : 0) != 0);
        }
    }

    public void testRemove() throws Exception {
        String returnedValue1;
        int i;
        GroupCacheAccess access = JCS.getGroupCacheInstance((String)"test");
        GroupCacheAccessUnitTest.assertNotNull((String)"We should have an access class", (Object)access);
        String key = "mykey";
        String group = "mygroup";
        String value = "myvalue";
        for (i = 0; i < 10; ++i) {
            access.putInGroup((Object)(key + i), group, (Object)(value + i));
        }
        for (i = 0; i < 10; ++i) {
            returnedValue1 = (String)access.getFromGroup((Object)(key + i), group);
            GroupCacheAccessUnitTest.assertEquals((String)"Wrong value returned.", (String)(value + i), (String)returnedValue1);
        }
        access.removeFromGroup((Object)(key + 0), group);
        GroupCacheAccessUnitTest.assertNull((String)"Should not be in cache", (Object)access.getFromGroup((Object)(key + 0), group));
        for (i = 1; i < 10; ++i) {
            returnedValue1 = (String)access.getFromGroup((Object)(key + i), group);
            GroupCacheAccessUnitTest.assertEquals((String)"Wrong value returned.", (String)(value + i), (String)returnedValue1);
        }
    }

    public void testInvalidate() throws Exception {
        String returnedValue1;
        int i;
        GroupCacheAccess access = JCS.getGroupCacheInstance((String)"test");
        GroupCacheAccessUnitTest.assertNotNull((String)"We should have an access class", (Object)access);
        String key = "mykey";
        String group = "mygroup";
        String value = "myvalue";
        for (i = 0; i < 10; ++i) {
            access.putInGroup((Object)(key + i), group + 0, (Object)(value + i));
        }
        for (i = 0; i < 10; ++i) {
            access.putInGroup((Object)(key + i), group + 1, (Object)(value + i));
        }
        for (i = 0; i < 10; ++i) {
            returnedValue1 = (String)access.getFromGroup((Object)(key + i), group + 0);
            GroupCacheAccessUnitTest.assertEquals((String)"Wrong value returned.", (String)(value + i), (String)returnedValue1);
            String returnedValue2 = (String)access.getFromGroup((Object)(key + i), group + 1);
            GroupCacheAccessUnitTest.assertEquals((String)"Wrong value returned.", (String)(value + i), (String)returnedValue2);
        }
        access.invalidateGroup(group + 0);
        for (i = 0; i < 10; ++i) {
            GroupCacheAccessUnitTest.assertNull((String)"Should not be in cache", (Object)access.getFromGroup((Object)(key + i), group + 0));
        }
        for (i = 0; i < 10; ++i) {
            returnedValue1 = (String)access.getFromGroup((Object)(key + i), group + 1);
            GroupCacheAccessUnitTest.assertEquals((String)"Wrong value returned.", (String)(value + i), (String)returnedValue1);
        }
    }

    public void testGroupCache() throws Exception {
        GroupCacheAccess access = JCS.getGroupCacheInstance((String)"testGroup");
        String groupName1 = "testgroup1";
        String groupName2 = "testgroup2";
        Set keys1 = access.getGroupKeys(groupName1);
        GroupCacheAccessUnitTest.assertNotNull((Object)keys1);
        GroupCacheAccessUnitTest.assertEquals((int)0, (int)keys1.size());
        Set keys2 = access.getGroupKeys(groupName2);
        GroupCacheAccessUnitTest.assertNotNull((Object)keys2);
        GroupCacheAccessUnitTest.assertEquals((int)0, (int)keys2.size());
        int numToInsertGroup1 = 10;
        for (int i = 0; i < numToInsertGroup1; ++i) {
            access.putInGroup((Object)String.valueOf(i), groupName1, (Object)i);
        }
        int numToInsertGroup2 = 50;
        for (int i = 0; i < numToInsertGroup2; ++i) {
            access.putInGroup((Object)String.valueOf(i), groupName2, (Object)(i + 1));
        }
        keys1 = access.getGroupKeys(groupName1);
        GroupCacheAccessUnitTest.assertNotNull((Object)keys1);
        GroupCacheAccessUnitTest.assertEquals((String)"Wrong number returned 1:", (int)10, (int)keys1.size());
        keys2 = access.getGroupKeys(groupName2);
        GroupCacheAccessUnitTest.assertNotNull((Object)keys2);
        GroupCacheAccessUnitTest.assertEquals((String)"Wrong number returned 2:", (int)50, (int)keys2.size());
        GroupCacheAccessUnitTest.assertEquals((Object)5, (Object)access.getFromGroup((Object)"5", groupName1));
        GroupCacheAccessUnitTest.assertEquals((Object)6, (Object)access.getFromGroup((Object)"5", groupName2));
        GroupCacheAccessUnitTest.assertTrue((boolean)access.getGroupNames().contains(groupName1));
        GroupCacheAccessUnitTest.assertTrue((boolean)access.getGroupNames().contains(groupName2));
    }
}

