/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk.indexed;

import java.util.HashSet;
import java.util.Map;
import junit.extensions.ActiveTestSuite;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.commons.jcs.JCS;
import org.apache.commons.jcs.access.CacheAccess;
import org.apache.commons.jcs.engine.behavior.ICacheElement;

public class IndexedDiskCacheNoMemoryUnitTest
extends TestCase {
    private static int items = 2000;

    public IndexedDiskCacheNoMemoryUnitTest(String testName) {
        super(testName);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{IndexedDiskCacheNoMemoryUnitTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    public static Test suite() {
        ActiveTestSuite suite = new ActiveTestSuite();
        suite.addTest((Test)new IndexedDiskCacheNoMemoryUnitTest("testIndexedDiskCache1"){

            public void runTest() throws Exception {
                this.runTestForRegion("indexedRegion1");
            }
        });
        suite.addTest((Test)new IndexedDiskCacheNoMemoryUnitTest("testIndexedDiskCache2"){

            public void runTest() throws Exception {
                this.runTestForRegion("indexedRegion2");
            }
        });
        suite.addTest((Test)new IndexedDiskCacheNoMemoryUnitTest("testIndexedDiskCache3"){

            public void runTest() throws Exception {
                this.runTestForRegion("indexedRegion3");
            }
        });
        return suite;
    }

    public void setUp() {
        JCS.setConfigFilename((String)"/TestDiskCacheNoMemory.ccf");
    }

    public void runTestForRegion(String region) throws Exception {
        int i;
        int i2;
        CacheAccess jcs = JCS.getInstance((String)region);
        for (i2 = 0; i2 <= items; ++i2) {
            jcs.put((Object)(i2 + ":key"), (Object)(region + " data " + i2));
        }
        for (i2 = 0; i2 <= items; ++i2) {
            String value = (String)jcs.get((Object)(i2 + ":key"));
            IndexedDiskCacheNoMemoryUnitTest.assertEquals((String)(region + " data " + i2), (String)value);
        }
        HashSet<String> keys = new HashSet<String>();
        for (int i3 = 0; i3 <= items; ++i3) {
            keys.add(i3 + ":key");
        }
        Map elements = jcs.getCacheElements(keys);
        for (i = 0; i <= items; ++i) {
            ICacheElement element = (ICacheElement)elements.get(i + ":key");
            IndexedDiskCacheNoMemoryUnitTest.assertNotNull((String)("element " + i + ":key is missing"), (Object)element);
            IndexedDiskCacheNoMemoryUnitTest.assertEquals((String)("value " + i + ":key"), (String)(region + " data " + i), (String)((String)element.getVal()));
        }
        for (i = 0; i <= items; ++i) {
            jcs.remove((Object)(i + ":key"));
        }
        for (i = 0; i <= items; ++i) {
            IndexedDiskCacheNoMemoryUnitTest.assertNull((String)("Removed key should be null: " + i + ":key\n stats " + jcs.getStats()), (Object)jcs.get((Object)(i + ":key")));
        }
    }
}

