/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk.indexed;

import junit.framework.TestCase;
import org.apache.commons.jcs.auxiliary.disk.DiskTestObject;
import org.apache.commons.jcs.auxiliary.disk.indexed.DiskTestObjectUtil;
import org.apache.commons.jcs.auxiliary.disk.indexed.IndexedDiskCache;
import org.apache.commons.jcs.auxiliary.disk.indexed.IndexedDiskCacheAttributes;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.utils.timing.SleepUtil;

public class IndexedDiskCacheOptimizationUnitTest
extends TestCase {
    public void testBasicOptimization() throws Exception {
        int removeCount = 50;
        IndexedDiskCacheAttributes cattr = new IndexedDiskCacheAttributes();
        cattr.setCacheName("testOptimization");
        cattr.setMaxKeySize(removeCount * 2);
        cattr.setOptimizeAtRemoveCount(removeCount);
        cattr.setDiskPath("target/test-sandbox/testOptimization");
        IndexedDiskCache disk = new IndexedDiskCache(cattr);
        disk.removeAll();
        int numberToInsert = removeCount * 3;
        ICacheElement<Integer, DiskTestObject>[] elements = DiskTestObjectUtil.createCacheElementsWithTestObjectsOfVariableSizes(numberToInsert, cattr.getCacheName());
        for (int i = 0; i < elements.length; ++i) {
            disk.processUpdate(elements[i]);
        }
        Thread.sleep(1000L);
        long sizeBeforeRemove = disk.getDataFileSize();
        for (int i = 0; i < removeCount; ++i) {
            disk.processRemove((Object)i);
        }
        SleepUtil.sleepAtLeast(1000L);
        disk.optimizeFile();
        long sizeAfterRemove = disk.getDataFileSize();
        long expectedSizeAfterRemove = DiskTestObjectUtil.totalSize(elements, removeCount, elements.length);
        if (expectedSizeAfterRemove != sizeAfterRemove) {
            SleepUtil.sleepAtLeast(2000L);
        }
        IndexedDiskCacheOptimizationUnitTest.assertTrue((String)("The post optimization size should be smaller.sizeAfterRemove=" + sizeAfterRemove + " sizeBeforeRemove= " + sizeBeforeRemove), (sizeAfterRemove < sizeBeforeRemove ? 1 : 0) != 0);
        IndexedDiskCacheOptimizationUnitTest.assertEquals((String)"The file size is not as expected size.", (long)expectedSizeAfterRemove, (long)sizeAfterRemove);
    }
}

