/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk.indexed;

import java.text.DecimalFormat;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.jcs.JCS;
import org.apache.commons.jcs.access.CacheAccess;
import org.apache.commons.jcs.auxiliary.disk.DiskTestObject;
import org.apache.commons.jcs.utils.timing.ElapsedTimer;

public class IndexedDiskCacheSteadyLoadTest
extends TestCase {
    private static final String LOG_DIVIDER = "---------------------------";
    private static Runtime rt = Runtime.getRuntime();
    private static DecimalFormat format = new DecimalFormat("#,###");

    public void testRunSteadyLoadTest() throws Exception {
        JCS.setConfigFilename((String)"/TestDiskCacheSteadyLoad.ccf");
        System.out.println("runSteadyLoadTest");
        IndexedDiskCacheSteadyLoadTest.logMemoryUsage();
        int numPerRun = 200;
        long pauseBetweenRuns = 1000L;
        int runCount = 0;
        int runs = 1000;
        int upperKB = 50;
        CacheAccess jcs = JCS.getInstance((String)(numPerRun / 2 + "aSecond"));
        ElapsedTimer timer = new ElapsedTimer();
        int numToGet = numPerRun * (runs / 10);
        for (int i = 0; i < numToGet; ++i) {
            jcs.get((Object)String.valueOf(i));
        }
        System.out.println(LOG_DIVIDER);
        System.out.println("After getting " + numToGet);
        System.out.println("Elapsed " + timer.getElapsedTimeString());
        IndexedDiskCacheSteadyLoadTest.logMemoryUsage();
        jcs.clear();
        Thread.sleep(3000L);
        System.out.println(LOG_DIVIDER);
        System.out.println("Start putting");
        long totalSize = 0L;
        int totalPut = 0;
        Random random = new Random(89L);
        while (runCount < runs) {
            ++runCount;
            for (int i = 0; i < numPerRun; ++i) {
                int kiloBytes = Math.max(upperKB / 2, random.nextInt(upperKB));
                int bytes = kiloBytes * 1024;
                totalSize += (long)bytes;
                DiskTestObject object = new DiskTestObject(i, new byte[bytes]);
                jcs.put((Object)String.valueOf(++totalPut), (Object)object);
            }
            if (runCount > 1) {
                for (int j = totalPut - numPerRun - numPerRun / 2; j < totalPut - numPerRun; ++j) {
                    jcs.remove((Object)String.valueOf(j));
                }
            }
            Thread.sleep(pauseBetweenRuns);
            if (runCount % 100 != 0) continue;
            System.out.println(LOG_DIVIDER);
            System.out.println("Elapsed " + timer.getElapsedTimeString());
            System.out.println("Run count: " + runCount + " Average size: " + totalSize / (long)totalPut + "\n" + jcs.getStats());
            IndexedDiskCacheSteadyLoadTest.logMemoryUsage();
        }
        Thread.sleep(3000L);
        System.out.println(jcs.getStats());
        IndexedDiskCacheSteadyLoadTest.logMemoryUsage();
        Thread.sleep(10000L);
        System.out.println(jcs.getStats());
        IndexedDiskCacheSteadyLoadTest.logMemoryUsage();
        System.gc();
        Thread.sleep(3000L);
        System.gc();
        System.out.println(jcs.getStats());
        IndexedDiskCacheSteadyLoadTest.logMemoryUsage();
    }

    private static void logMemoryUsage() {
        long byte2MB = 0x100000L;
        long total = rt.totalMemory() / byte2MB;
        long free = rt.freeMemory() / byte2MB;
        long used = total - free;
        System.out.println(LOG_DIVIDER);
        System.out.println("Memory: Used:" + format.format(used) + "MB Free:" + format.format(free) + "MB Total:" + format.format(total) + "MB");
    }
}

