/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote;

import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.server.ExportException;
import java.rmi.server.UnicastRemoteObject;
import org.apache.commons.jcs.access.exception.CacheException;
import org.apache.commons.jcs.access.exception.ObjectExistsException;
import org.apache.commons.jcs.auxiliary.remote.RemoteUtils;
import org.apache.commons.jcs.auxiliary.remote.behavior.IRemoteCacheConstants;
import org.apache.commons.jcs.auxiliary.remote.behavior.IRemoteCacheListener;
import org.apache.commons.jcs.auxiliary.remote.server.behavior.RemoteType;
import org.apache.commons.jcs.engine.CacheElement;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICacheListener;
import org.apache.commons.jcs.engine.behavior.ICacheObserver;
import org.apache.commons.jcs.engine.behavior.ICacheService;

public class RemoteCacheClientTester
implements IRemoteCacheListener<String, String>,
IRemoteCacheConstants,
Remote {
    protected ICacheObserver watch;
    protected ICacheService<String, String> cache;
    final String host;
    final int port;
    final int count;
    protected static long listenerId = 0L;

    public RemoteType getRemoteType() throws IOException {
        return RemoteType.LOCAL;
    }

    public RemoteCacheClientTester(int count) throws MalformedURLException, NotBoundException, IOException {
        this(count, true, true, false);
    }

    public RemoteCacheClientTester(int count, boolean write, boolean read, boolean delete) throws MalformedURLException, NotBoundException, IOException {
        this("", 1099, count, write, read, delete);
    }

    public RemoteCacheClientTester(String host, int port, int count, boolean write, boolean read, boolean delete) throws MalformedURLException, NotBoundException, IOException {
        this.count = count;
        this.host = host;
        this.port = port;
        ExportException ee = null;
        try {
            UnicastRemoteObject.exportObject(this);
        }
        catch (ExportException e) {
            ee = e;
            ee.printStackTrace();
        }
        String service = System.getProperty("remote.cache.service.name");
        if (service == null) {
            service = REMOTE_CACHE_SERVICE_VAL;
        }
        String registry = RemoteUtils.getNamingURL((String)host, (int)port, (String)service);
        RemoteCacheClientTester.p("looking up server " + registry);
        Remote obj = Naming.lookup(registry);
        RemoteCacheClientTester.p("server found");
        this.cache = (ICacheService)obj;
        this.watch = (ICacheObserver)obj;
        RemoteCacheClientTester.p("subscribing to the server");
        this.watch.addCacheListener("testCache", (ICacheListener)this);
        CacheElement cb = new CacheElement("testCache", (Object)"testKey", (Object)"testVal");
        for (int i = 0; i < count; ++i) {
            cb = new CacheElement("testCache", (Object)("" + i), (Object)("" + i));
            if (delete) {
                RemoteCacheClientTester.p("deleting a cache item from the server " + i);
                this.cache.remove(cb.getCacheName(), cb.getKey());
            }
            if (write) {
                RemoteCacheClientTester.p("putting a cache bean to the server " + i);
                try {
                    this.cache.update((ICacheElement)cb);
                }
                catch (ObjectExistsException oee) {
                    RemoteCacheClientTester.p(oee.toString());
                }
            }
            if (!read) continue;
            try {
                ICacheElement val = this.cache.get(cb.getCacheName(), cb.getKey());
                RemoteCacheClientTester.p("get " + (String)cb.getKey() + " returns " + val);
                continue;
            }
            catch (CacheException cacheException) {
                // empty catch block
            }
        }
    }

    public void handlePut(ICacheElement<String, String> cb) throws IOException {
        RemoteCacheClientTester.p("handlePut> cb=" + cb);
    }

    public void handleRemove(String cacheName, String key) throws IOException {
        RemoteCacheClientTester.p("handleRemove> cacheName=" + cacheName + ", key=" + key);
    }

    public void handleRemoveAll(String cacheName) throws IOException {
        RemoteCacheClientTester.p("handleRemove> cacheName=" + cacheName);
    }

    public void handleDispose(String cacheName) throws IOException {
        RemoteCacheClientTester.p("handleDispose> cacheName=" + cacheName);
    }

    public static void main(String[] args) throws Exception {
        int count = 0;
        boolean read = false;
        boolean write = false;
        boolean delete = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (!read) {
                    boolean bl = read = args[i].indexOf("r") != -1;
                }
                if (!write) {
                    boolean bl = write = args[i].indexOf("w") != -1;
                }
                if (delete) continue;
                delete = args[i].indexOf("d") != -1;
                continue;
            }
            count = Integer.parseInt(args[i]);
        }
        new RemoteCacheClientTester(count, write, read, delete);
    }

    public void setListenerId(long id) throws IOException {
        listenerId = id;
        RemoteCacheClientTester.p("listenerId = " + id);
    }

    public long getListenerId() throws IOException {
        return listenerId;
    }

    private static void p(String s) {
        System.out.println(s);
    }

    public String getLocalHostAddress() throws IOException {
        return null;
    }

    public void dispose() throws IOException {
    }
}

