/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote;

import java.util.Properties;
import junit.framework.TestCase;
import org.apache.commons.jcs.JCS;
import org.apache.commons.jcs.access.CacheAccess;
import org.apache.commons.jcs.auxiliary.MockCacheEventLogger;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheAttributes;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheFactory;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheManager;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheNoWait;
import org.apache.commons.jcs.auxiliary.remote.RemoteUtils;
import org.apache.commons.jcs.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.commons.jcs.auxiliary.remote.server.RemoteCacheServerFactory;
import org.apache.commons.jcs.engine.CacheElement;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.control.MockCompositeCacheManager;
import org.apache.commons.jcs.engine.control.MockElementSerializer;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestRemoteCache
extends TestCase {
    private static final Log log = LogFactory.getLog(TestRemoteCache.class);

    public TestRemoteCache() {
        try {
            System.out.println("main> creating registry on the localhost");
            RemoteUtils.createRegistry((int)1101);
            Properties config = RemoteUtils.loadProps((String)"/TestRemoteServer.ccf");
            RemoteCacheServerFactory.startup((String)"localhost", (int)1101, (Properties)config);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setUp() {
        JCS.setConfigFilename((String)"/TestRemoteClient.ccf");
    }

    public void skiptestSimpleSend() throws Exception {
        log.info((Object)"testSimpleSend");
        CacheAccess cache = JCS.getInstance((String)"testCache");
        log.info((Object)("cache = " + cache));
        for (int i = 0; i < 1000; ++i) {
            cache.put((Object)("key" + i), (Object)("data" + i));
            log.info((Object)("put " + i));
        }
    }

    public void testService() throws Exception {
        Thread.sleep(100L);
        MockCompositeCacheManager cacheMgr = new MockCompositeCacheManager();
        RemoteCacheAttributes rca = new RemoteCacheAttributes();
        rca.setRemoteLocation("localhost", 1101);
        rca.setCacheName("testCache");
        RemoteCacheFactory factory = new RemoteCacheFactory();
        factory.initialize();
        RemoteCacheManager mgr = factory.getManager((IRemoteCacheAttributes)rca, (ICompositeCacheManager)cacheMgr, (ICacheEventLogger)new MockCacheEventLogger(), (IElementSerializer)new MockElementSerializer());
        RemoteCacheNoWait cache = mgr.getCache((IRemoteCacheAttributes)rca);
        int numMes = 100;
        for (int i = 0; i < numMes; ++i) {
            String message = "adsfasasfasfasdasf";
            CacheElement ce = new CacheElement("key1", (Object)("data" + i), (Object)message);
            cache.update((ICacheElement)ce);
        }
    }
}

